# 🤰🏾 MamaHub - Pregnancy & Baby Health App

A modern, inclusive pregnancy and baby health tracking application with African cultural themes and illustrations. Supporting mothers across Africa through every step of their pregnancy and motherhood journey.

## 🌍 Features

### Home Page
- **African Baby Cartoons & Illustrations** - Adorable character representations including Kwame, Amara, Jamal, and Zainab
- **Pregnancy Milestone Infographics** - Interactive timeline tracking baby development from conception to birth
- **African Mother Inspiration Cards** - Stories and wisdom from inspiring mothers across the continent (Nigeria, Kenya, South Africa, Uganda, Tanzania, Ghana)
- **Community Highlights** - Real-time stats showing 145+ support groups, 12,450+ connected mothers, 3,890+ success stories

### Community Page
- **African-Themed Avatars** - Beautifully represented community members with their locations and status
- **Community Statistics Dashboard**
  - Active discussions (2,340+)
  - Helpful posts (8,765+)
  - Resource guides (156+)
  - Expert answers (4,230+)
  - Success milestones (3,456+)
  - Community rating (4.9/5 stars)

### Baby Growth Tracker
- **African Baby Illustrations** - Month-by-month visual representations of baby development
- **Growth Progress Charts**
  - Weight gain tracking
  - Height/length growth
  - Development milestones

### Pregnancy Milestones Page
- Trimester-by-trimester breakdown
- Week-by-week development details
- Health tips and guidelines

## 🛠️ Tech Stack

- **Framework**: Next.js 14
- **React**: 18.2
- **Styling**: Tailwind CSS 3.3
- **Language**: TypeScript 5

## 🚀 Getting Started

1. Install dependencies: `npm install`
2. Run development server: `npm run dev`
3. Open http://localhost:3000

## 📱 Pages

- **Home** (`/`) - African baby cartoons, pregnancy milestones, inspiration cards, community highlights
- **Community** (`/community`) - African-themed avatars and community statistics
- **Baby Tracker** (`/baby-tracker`) - Interactive baby growth tracker with African illustrations
- **Milestones** (`/milestones`) - Detailed pregnancy timeline and health tips

## 🌟 Key Features

✅ African Cultural Representation  
✅ Responsive Design  
✅ Beautiful UI with Warm African Colors  
✅ Interactive Components  
✅ Community-Focused Features  
✅ Informative Health Content  

---

**MamaHub** - Supporting Every Mother's Journey 🤰🏾👶🏾🌍
