# 🤰🏾 MamaHub - Pregnancy & Baby Health App

A modern, inclusive pregnancy and baby health tracking application with African cultural themes and illustrations. Supporting mothers across Africa through every step of their pregnancy and motherhood journey.

## 🌍 Features

### Home Page
- **African Baby Cartoons & Illustrations** - Adorable character representations including Kwame, Amara, Jamal, and Zainab
- **Pregnancy Milestone Infographics** - Interactive timeline tracking baby development from conception to birth
- **African Mother Inspiration Cards** - Stories and wisdom from inspiring mothers across the continent (Nigeria, Kenya, South Africa, Uganda, Tanzania, Ghana)
- **Community Highlights** - Real-time stats showing 145+ support groups, 12,450+ connected mothers, 3,890+ success stories

### Community Page
- **African-Themed Avatars** - Beautifully represented community members with their locations and status
- **Community Statistics Dashboard**
  - Active discussions (2,340+)
  - Helpful posts (8,765+)
  - Resource guides (156+)
  - Expert answers (4,230+)
  - Success milestones (3,456+)
  - Community rating (4.9/5 stars)

### Baby Growth Tracker
- **African Baby Illustrations** - Month-by-month visual representations of baby development
- **Growth Progress Charts**
  - Weight gain tracking
  - Height/length growth
  - Development milestones
- **Key Milestones**
  - Newborn to 12 months tracking
  - Interactive age selector
  - Detailed development information

### Pregnancy Milestones Page
- Trimester-by-trimester breakdown
- Week-by-week development details
- Symptom information and management
- Health tips and guidelines

## 🎨 Design

### Color Palette
- **Earth**: #8B6B47 - Primary browns reflecting African soil and connection to nature
- **Sand**: #D4AF86 - Warm sand tones
- **Sunset**: #E07644 - Vibrant African sunset colors
- **Forest**: #2D5016 - Deep African forest greens
- **Sky**: #87CEEB - Calming sky blues
- **Warm**: #F4A460 - Warm accent colors

### Typography
- Clean, readable fonts
- Accessible color contrasts
- Mobile-responsive design

## 🛠️ Tech Stack

- **Framework**: Next.js 14
- **React**: 18.2
- **Styling**: Tailwind CSS 3.3
- **Language**: TypeScript 5
- **Build Tool**: Next.js built-in

## 📁 Project Structure

```
Pregnancy-App/
├── app/
│   ├── page.tsx              # Home page
│   ├── layout.tsx            # Root layout
│   ├── globals.css           # Global styles
│   ├── community/
│   │   └── page.tsx          # Community page
│   ├── baby-tracker/
│   │   └── page.tsx          # Baby growth tracker
│   └── milestones/
│       └── page.tsx          # Pregnancy milestones
├── components/
│   ├── Navigation.tsx        # Main navigation
│   ├── Hero.tsx              # Hero section
│   ├── AfricanBabyCartoons.tsx
│   ├── PregnancyMilestones.tsx
│   ├── MotherInspirationCards.tsx
│   ├── CommunityHighlights.tsx
│   ├── CommunityAvatars.tsx
│   ├── CommunityStats.tsx
│   ├── BabyGrowthTracker.tsx
│   └── Footer.tsx
├── package.json
├── tsconfig.json
├── tailwind.config.ts
├── postcss.config.js
└── next.config.js
```

## 🚀 Getting Started

### Prerequisites
- Node.js 18+ 
- npm or yarn package manager

### Installation

1. Clone the repository
```bash
git clone https://github.com/dannyqym-qaris/Pregnancy-App.git
cd Pregnancy-App
```

2. Install dependencies
```bash
npm install
```

3. Run development server
```bash
npm run dev
```

4. Open browser and navigate to
```
http://localhost:3000
```

### Build for Production
```bash
npm run build
npm run start
```

## 📱 Pages

### Home (`/`)
- Welcome hero section
- African baby character stories
- Pregnancy milestone timeline
- Mother inspiration cards
- Community statistics

### Community (`/community`)
- Community member avatars with African representation
- Detailed statistics dashboard
- Support groups and resources
- Discussion forums

### Baby Tracker (`/baby-tracker`)
- Interactive baby growth tracker
- Month-by-month development visualization
- Growth progress charts
- Healthy baby milestone guidelines

### Milestones (`/milestones`)
- Detailed pregnancy timeline
- Trimester information
- Healthy pregnancy tips
- Healthcare guidelines

## 🎯 Component Overview

### AfricanBabyCartoons
Displays charming African baby character cards with descriptions and illustrations.

### PregnancyMilestones
Interactive timeline showing pregnancy development from week 4 to week 40 with icons and details.

### MotherInspirationCards
Inspirational cards featuring African mothers with their stories and specialties.

### CommunityHighlights
Statistics showing active communities, connected mothers, and success stories.

### CommunityAvatars
Grid display of community members with African-themed avatars and status badges.

### CommunityStats
Dashboard showing discussion activity, resources, and community engagement metrics.

### BabyGrowthTracker
Interactive tracker following baby development from newborn to 12 months with growth charts.

## 🌟 Key Features

✅ **African Cultural Representation** - Celebrate and honor African heritage throughout the app
✅ **Responsive Design** - Works seamlessly on mobile, tablet, and desktop
✅ **Accessible** - WCAG compliant with proper contrast ratios
✅ **Fast Performance** - Optimized images and efficient code
✅ **Community-Focused** - Features real community engagement and support
✅ **Informative** - Evidence-based health information
✅ **Beautiful UI** - Warm, welcoming design with African color themes

## 👩‍💻 Development

### Available Scripts
- `npm run dev` - Start development server
- `npm run build` - Build for production
- `npm run start` - Start production server
- `npm run lint` - Run linting

### Component Development
All components are client-side React components with proper TypeScript types. Use the `'use client'` directive for interactive components.

## 🤝 Contributing

Contributions are welcome! Please feel free to submit pull requests with improvements or report issues.

## 📄 License

This project is open source and available under the MIT License.

## 🙏 Acknowledgments

Built with love for African mothers everywhere, celebrating the strength, wisdom, and beauty of motherhood across the continent.

---

**MamaHub** - Supporting Every Mother's Journey 🤰🏾👶🏾🌍
