import Navigation from '@/components/Navigation'
import BottomNavigation from '@/components/BottomNavigation'
import EnhancedBabyGrowthTracker from '@/components/EnhancedBabyGrowthTracker'
import Footer from '@/components/Footer'

export const metadata = {
  title: 'Baby Growth Tracker | Pregnancy App',
  description: 'Track your baby\'s milestones, measurements, and development with photos, charts, and expert guidance',
}

export default function BabyGrowthPage() {
  return (
    <main>
      <Navigation />
      <div className="max-w-6xl mx-auto px-4 py-8 pb-32">
        <EnhancedBabyGrowthTracker />
      </div>
      <BottomNavigation />
      <Footer />
    </main>
  )
}
