import Navigation from '@/components/Navigation'
import CommunityAvatars from '@/components/CommunityAvatars'
import CommunityStats from '@/components/CommunityStats'
import CommunityEnhancements from '@/components/CommunityEnhancements'
import CommunityHighlights from '@/components/CommunityHighlights'
import Footer from '@/components/Footer'

export const metadata = {
  title: 'Community | Pregnancy App',
  description: 'Connect with other mothers and share pregnancy experiences',
}

export default function CommunityPage() {
  return (
    <main>
      <Navigation />
      
      <section className="bg-gradient-to-r from-hotpink to-hotpink-dark py-12 px-4 text-white">
        <div className="max-w-6xl mx-auto text-center">
          <h1 className="text-5xl md:text-6xl font-bold mb-4">Our Community</h1>
          <p className="text-xl md:text-2xl text-hotpink-light">
            Connected mothers supporting each other across Africa 🌍
          </p>
        </div>
      </section>

      <section className="py-12 px-4">
        <div className="max-w-6xl mx-auto">
          <CommunityAvatars />
        </div>
      </section>

      <section className="py-12 px-4 bg-hotpink/5">
        <div className="max-w-6xl mx-auto">
          <CommunityStats />
        </div>
      </section>

      <section className="py-12 px-4">
        <div className="max-w-6xl mx-auto">
          <CommunityEnhancements />
        </div>
      </section>

      <section className="py-12 px-4 bg-gradient-to-r from-hotpink/10 to-hotpink-light/10">
        <div className="max-w-6xl mx-auto">
          <h2 className="text-3xl font-bold text-hotpink mb-8 text-center">Join Our Community</h2>
          
          <div className="grid md:grid-cols-3 gap-6">
            <div className="bg-white border-2 border-hotpink-light rounded-lg p-6 text-center hover:shadow-lg transition hover:border-hotpink">
              <div className="text-5xl mb-4">👥</div>
              <h3 className="text-xl font-bold text-hotpink mb-2">Support Groups</h3>
              <p className="text-gray-600 mb-4">Join local support groups and connect with mothers near you</p>
              <button className="bg-hotpink hover:bg-hotpink-dark text-white font-bold py-2 px-4 rounded transition">
                Find Groups
              </button>
            </div>

            <div className="bg-white border-2 border-hotpink-light rounded-lg p-6 text-center hover:shadow-lg transition hover:border-hotpink">
              <div className="text-5xl mb-4">💬</div>
              <h3 className="text-xl font-bold text-hotpink mb-2">Discussion Boards</h3>
              <p className="text-gray-600 mb-4">Share experiences and ask questions in our active forums</p>
              <button className="bg-hotpink hover:bg-hotpink-dark text-white font-bold py-2 px-4 rounded transition">
                View Forums
              </button>
            </div>

            <div className="bg-white border-2 border-hotpink-light rounded-lg p-6 text-center hover:shadow-lg transition hover:border-hotpink">
              <div className="text-5xl mb-4">📚</div>
              <h3 className="text-xl font-bold text-hotpink mb-2">Resources</h3>
              <p className="text-gray-600 mb-4">Access expert advice and curated health resources</p>
              <button className="bg-hotpink hover:bg-hotpink-dark text-white font-bold py-2 px-4 rounded transition">
                Browse Resources
              </button>
            </div>
          </div>
        </div>
      </section>

      <Footer />
    </main>
  )
}
