import type { Metadata } from 'next'
import './globals.css'

export const metadata: Metadata = {
  title: 'Pregnancy & Baby Health App',
  description: 'Track your pregnancy journey with African cultural themes and support',
}

export default function RootLayout({
  children,
}: {
  children: React.ReactNode
}) {
  return (
    <html lang="en">
      <body className="bg-warm/10 text-gray-900">
        {children}
      </body>
    </html>
  )
}
