import Navigation from '@/components/Navigation'
import PregnancyMilestones from '@/components/PregnancyMilestones'
import MilestonesEnhancements from '@/components/MilestonesEnhancements'
import Footer from '@/components/Footer'

export const metadata = {
  title: 'Milestones | Pregnancy App',
  description: 'Track your incredible pregnancy journey week by week',
}

export default function MilestonesPage() {
  return (
    <main>
      <Navigation />
      
      <section className="bg-gradient-to-r from-hotpink to-hotpink-dark py-12 px-4 text-white">
        <div className="max-w-6xl mx-auto text-center">
          <h1 className="text-5xl md:text-6xl font-bold mb-4">Pregnancy Milestones</h1>
          <p className="text-xl md:text-2xl text-hotpink-light">
            Track your incredible pregnancy journey week by week ✨
          </p>
        </div>
      </section>

      <section className="py-12 px-4">
        <div className="max-w-6xl mx-auto">
          <PregnancyMilestones />
        </div>
      </section>

      <section className="py-12 px-4">
        <div className="max-w-6xl mx-auto">
          <MilestonesEnhancements />
        </div>
      </section>

      <section className="py-12 px-4 bg-sand/20">
        <div className="max-w-6xl mx-auto">
          <h2 className="text-3xl font-bold text-earth mb-8 text-center">What To Expect</h2>
          
          <div className="grid md:grid-cols-3 gap-6">
            <div className="bg-white rounded-lg p-6 border border-sand/30">
              <h3 className="text-xl font-bold text-earth mb-3">First Trimester</h3>
              <ul className="space-y-2 text-gray-700 text-sm">
                <li>✓ Morning sickness may occur</li>
                <li>✓ Fatigue is common</li>
                <li>✓ Frequent urination</li>
                <li>✓ Mood swings</li>
                <li>✓ Breast tenderness</li>
              </ul>
            </div>

            <div className="bg-white rounded-lg p-6 border border-sand/30">
              <h3 className="text-xl font-bold text-earth mb-3">Second Trimester</h3>
              <ul className="space-y-2 text-gray-700 text-sm">
                <li>✓ Feel baby kick</li>
                <li>✓ Energy returns</li>
                <li>✓ Skin glows</li>
                <li>✓ Baby bump visible</li>
                <li>✓ Digestive changes</li>
              </ul>
            </div>

            <div className="bg-white rounded-lg p-6 border border-sand/30">
              <h3 className="text-xl font-bold text-earth mb-3">Third Trimester</h3>
              <ul className="space-y-2 text-gray-700 text-sm">
                <li>✓ Frequent movements</li>
                <li>✓ Back pain</li>
                <li>✓ Sleep difficulties</li>
                <li>✓ Braxton Hicks</li>
                <li>✓ Nesting instinct</li>
              </ul>
            </div>
          </div>
        </div>
      </section>

      <section className="py-12 px-4">
        <div className="max-w-6xl mx-auto">
          <h2 className="text-3xl font-bold text-earth mb-8 text-center">Healthy Pregnancy Tips</h2>
          
          <div className="grid md:grid-cols-2 gap-6">
            <div className="bg-earth/5 rounded-lg p-6 border-l-4 border-earth">
              <h4 className="text-lg font-bold text-earth mb-3">🥗 Nutrition</h4>
              <p className="text-gray-700 text-sm leading-relaxed">
                Eat a balanced diet rich in fruits, vegetables, lean proteins, and whole grains. Include African staples like millet, sorghum, and legumes. Prenatal vitamins are essential for optimal health.
              </p>
            </div>

            <div className="bg-earth/5 rounded-lg p-6 border-l-4 border-earth">
              <h4 className="text-lg font-bold text-earth mb-3">🏃 Exercise</h4>
              <p className="text-gray-700 text-sm leading-relaxed">
                Stay active with gentle exercises like walking, swimming, or pregnancy yoga. Aim for 150 minutes of moderate activity weekly. Always consult your healthcare provider first.
              </p>
            </div>

            <div className="bg-earth/5 rounded-lg p-6 border-l-4 border-earth">
              <h4 className="text-lg font-bold text-earth mb-3">😴 Rest</h4>
              <p className="text-gray-700 text-sm leading-relaxed">
                Get adequate sleep and rest when needed. Use pregnancy pillows for comfort. Manage stress through relaxation, meditation, or connecting with support groups.
              </p>
            </div>

            <div className="bg-earth/5 rounded-lg p-6 border-l-4 border-earth">
              <h4 className="text-lg font-bold text-earth mb-3">👨‍⚕️ Healthcare</h4>
              <p className="text-gray-700 text-sm leading-relaxed">
                Attend all prenatal check-ups regularly. Discuss any concerns with your healthcare provider. Stay informed about what to expect at each stage.
              </p>
            </div>
          </div>
        </div>
      </section>

      <Footer />
    </main>
  )
}
