import Navigation from '@/components/Navigation'
import Dashboard from '@/components/Dashboard'
import AfricanBabyCartoons from '@/components/AfricanBabyCartoons'
import PregnancyMilestones from '@/components/PregnancyMilestones'
import MotherInspirationCards from '@/components/MotherInspirationCards'
import BabyGrowthTracker from '@/components/BabyGrowthTracker'
import CommunityHighlights from '@/components/CommunityHighlights'
import BottomNavigation from '@/components/BottomNavigation'
import Footer from '@/components/Footer'

export const metadata = {
  title: 'Home | Pregnancy App',
  description: 'Your African-inspired pregnancy companion with personalized tracking and community support',
}

export default function Home() {
  return (
    <main>
      <Navigation />
      
      {/* Dashboard Section */}
      <div className="max-w-6xl mx-auto px-4 py-8">
        <Dashboard />
      </div>

      {/* African Baby Cartoons Section */}
      <AfricanBabyCartoons />

      {/* Pregnancy Milestones Section */}
      <PregnancyMilestones />

      {/* Mother Inspiration Cards Section */}
      <MotherInspirationCards />

      {/* Baby Growth Tracker Section */}
      <div className="max-w-6xl mx-auto px-4 py-8">
        <BabyGrowthTracker />
      </div>

      {/* Community Highlights Section */}
      <CommunityHighlights />

      <div className="pb-32" />
      <BottomNavigation />
      <Footer />
    </main>
  )
}
