'use client'

export default function AfricanBabyCartoons() {
  const babies = [
    {
      id: 1,
      name: 'Little Kwame',
      illustration: '👶🏾',
      color: 'bg-orange-100',
      description: 'A cheerful baby always ready for adventure!'
    },
    {
      id: 2,
      name: 'Sweet Amara',
      illustration: '🍼',
      color: 'bg-amber-100',
      description: 'Growing strong and healthy every day!'
    },
    {
      id: 3,
      name: 'Happy Jamal',
      illustration: '👶🏾',
      color: 'bg-yellow-100',
      description: 'Exploring the world with wonder and joy!'
    },
    {
      id: 4,
      name: 'Joy Zainab',
      illustration: '🎈',
      color: 'bg-rose-100',
      description: 'Surrounded by love and laughter!'
    }
  ]

  return (
    <section className="py-12 px-4 bg-gradient-to-r from-hotpink/10 to-hotpink-light/10">
      <div className="max-w-6xl mx-auto">
        <h2 className="text-3xl font-bold text-center mb-2 text-hotpink">African Baby Illustrations</h2>
        <p className="text-center text-gray-600 mb-8">Meet our collection of adorable African baby characters</p>
        
        <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-4">
          {babies.map((baby) => (
            <div key={baby.id} className={`${baby.color} rounded-lg p-6 text-center hover:shadow-lg transition transform hover:scale-105 border-2 border-hotpink-light`}>
              <div className="text-6xl mb-4">{baby.illustration}</div>
              <h3 className="text-xl font-bold text-hotpink mb-2">{baby.name}</h3>
              <p className="text-sm text-gray-700">{baby.description}</p>
            </div>
          ))}
        </div>
      </div>
    </section>
  )
}
