'use client'

import { useState } from 'react'

export default function AfricanMealPlanner() {
  const [selectedTrimester, setSelectedTrimester] = useState(1)
  const [selectedDay, setSelectedDay] = useState('Monday')

  const africanMeals = {
    1: {
      name: 'First Trimester',
      note: 'Focus on folate, iron, and managing nausea',
      meals: {
        Monday: [
          { meal: 'Breakfast', food: 'Ugali with spinach & eggs', nutrition: 'Folate, Iron, Protein', calories: 350 },
          { meal: 'Snack', food: 'Plantain chips & avocado', nutrition: 'Potassium, Healthy fats', calories: 150 },
          { meal: 'Lunch', food: 'Lentil stew with basmati rice', nutrition: 'Iron, Folate, Fiber', calories: 450 },
          { meal: 'Snack', food: 'Dates & almonds', nutrition: 'Iron, Calcium', calories: 200 },
          { meal: 'Dinner', food: 'Grilled tilapia with cassava leaves', nutrition: 'Omega-3, Iron, Calcium', calories: 400 }
        ],
        Tuesday: [
          { meal: 'Breakfast', food: 'Millet porridge with banana', nutrition: 'Fiber, Potassium, B vitamins', calories: 320 },
          { meal: 'Snack', food: 'Groundnuts & ginger tea', nutrition: 'Protein, Reduces nausea', calories: 180 },
          { meal: 'Lunch', food: 'Beans soup with sweet potato', nutrition: 'Fiber, Iron, Folate', calories: 480 },
          { meal: 'Snack', food: 'Watermelon & coconut water', nutrition: 'Hydration, Potassium', calories: 120 },
          { meal: 'Dinner', food: 'Chicken peanut stew with fufu', nutrition: 'Protein, Calcium, Iron', calories: 420 }
        ],
        Wednesday: [
          { meal: 'Breakfast', food: 'Sorghum pancakes with berries', nutrition: 'Folate, Antioxidants', calories: 340 },
          { meal: 'Snack', food: 'Papaya & yogurt', nutrition: 'Folate, Probiotics, Digestion', calories: 160 },
          { meal: 'Lunch', food: 'Moringa stew with millet', nutrition: 'Iron, Calcium, Vitamins', calories: 460 },
          { meal: 'Snack', food: 'Roasted chickpeas', nutrition: 'Protein, Folate', calories: 140 },
          { meal: 'Dinner', food: 'Beef with leafy greens & yam', nutrition: 'Iron, Protein, Calcium', calories: 440 }
        ],
        Thursday: [
          { meal: 'Breakfast', food: 'Coconut rice porridge', nutrition: 'Carbs, Healthy fats', calories: 360 },
          { meal: 'Snack', food: 'Mango & almond butter', nutrition: 'Folate, Healthy fats', calories: 170 },
          { meal: 'Lunch', food: 'Okra soup with whole grain bread', nutrition: 'Folate, Fiber, Iron', calories: 420 },
          { meal: 'Snack', food: 'Boiled eggs & tomatoes', nutrition: 'Protein, Lycopene', calories: 130 },
          { meal: 'Dinner', food: 'Fish curry with brown rice', nutrition: 'Omega-3, B vitamins', calories: 450 }
        ],
        Friday: [
          { meal: 'Breakfast', food: 'Fonio (African grain) with egg', nutrition: 'Complete protein, Iron', calories: 350 },
          { meal: 'Snack', food: 'Hibiscus juice & crackers', nutrition: 'Iron, Hydration', calories: 140 },
          { meal: 'Lunch', food: 'Black-eyed peas with greens', nutrition: 'Folate, Iron, Fiber', calories: 440 },
          { meal: 'Snack', food: 'Dates & sesame paste', nutrition: 'Iron, Calcium, Healthy fats', calories: 180 },
          { meal: 'Dinner', food: 'Grilled chicken with plantain', nutrition: 'Protein, Potassium', calories: 430 }
        ],
        Saturday: [
          { meal: 'Breakfast', food: 'Injera with lentils', nutrition: 'Folate, Iron, Fiber', calories: 380 },
          { meal: 'Snack', food: 'Paw paw & coconut milk', nutrition: 'Folate, Digestion aid', calories: 150 },
          { meal: 'Lunch', food: 'Beef stew with cassava', nutrition: 'Iron, Protein, Carbs', calories: 470 },
          { meal: 'Snack', food: 'Roasted corn & peanut butter', nutrition: 'Protein, B vitamins', calories: 200 },
          { meal: 'Dinner', food: 'Sardines with yam & vegetables', nutrition: 'Omega-3, Calcium, Iron', calories: 420 }
        ],
        Sunday: [
          { meal: 'Breakfast', food: 'Cassava porridge with milk', nutrition: 'Carbs, Calcium, Protein', calories: 370 },
          { meal: 'Snack', food: 'Passion fruit & almonds', nutrition: 'Vitamins, Healthy fats', calories: 160 },
          { meal: 'Lunch', food: 'Jollof rice with chicken & veggies', nutrition: 'B vitamins, Protein, Folate', calories: 480 },
          { meal: 'Snack', food: 'Ginger tea & whole wheat bread', nutrition: 'Ginger aids nausea', calories: 120 },
          { meal: 'Dinner', food: 'Fish stew with sweet potato & spinach', nutrition: 'Omega-3, Iron, Folate', calories: 450 }
        ]
      }
    },
    2: {
      name: 'Second Trimester',
      note: 'Increase calories, focus on calcium and protein',
      meals: {
        Monday: [
          { meal: 'Breakfast', food: 'Millet with egg & orange', nutrition: 'Fiber, Protein, Vitamin C', calories: 420 },
          { meal: 'Snack', food: 'Yogurt with honey & nuts', nutrition: 'Calcium, Probiotics', calories: 200 },
          { meal: 'Lunch', food: 'Chickpea curry with millet bread', nutrition: 'Protein, Iron, Calcium', calories: 550 },
          { meal: 'Snack', food: 'Banana & peanut butter', nutrition: 'Potassium, Protein', calories: 220 },
          { meal: 'Dinner', food: 'Tilapia with cassava leaves & rice', nutrition: 'Calcium, Iron, Omega-3', calories: 520 }
        ],
        Tuesday: [
          { meal: 'Breakfast', food: 'Shiro (Ethiopian chickpea stew) with injera', nutrition: 'Protein, Folate', calories: 440 },
          { meal: 'Snack', food: 'Dried fruit & sesame seeds', nutrition: 'Iron, Calcium', calories: 210 },
          { meal: 'Lunch', food: 'Beef dooba with potatoes & greens', nutrition: 'Iron, Protein, Folate', calories: 560 },
          { meal: 'Snack', food: 'Mango & milk shake', nutrition: 'Calcium, Vitamins', calories: 200 },
          { meal: 'Dinner', food: 'Okra stew with fish & fufu', nutrition: 'Folate, Calcium, Iron', calories: 530 }
        ],
        Wednesday: [
          { meal: 'Breakfast', food: 'Coconut porridge with egg', nutrition: 'Healthy fats, Protein', calories: 430 },
          { meal: 'Snack', food: 'Avocado toast on whole grain', nutrition: 'Healthy fats, Fiber', calories: 220 },
          { meal: 'Lunch', food: 'Lentil & millet salad with chicken', nutrition: 'Protein, Fiber, Folate', calories: 540 },
          { meal: 'Snack', food: 'Papaya & sunflower seeds', nutrition: 'Folate, Vitamin E', calories: 190 },
          { meal: 'Dinner', food: 'Sardine stew with black-eyed peas', nutrition: 'Omega-3, Iron, Calcium', calories: 510 }
        ],
        Thursday: [
          { meal: 'Breakfast', food: 'Sorghum pancakes with peanut sauce', nutrition: 'Protein, B vitamins', calories: 450 },
          { meal: 'Snack', food: 'Boiled groundnuts & watermelon', nutrition: 'Protein, Hydration', calories: 200 },
          { meal: 'Lunch', food: 'Bean soup with corn bread', nutrition: 'Fiber, Protein, Carbs', calories: 550 },
          { meal: 'Snack', food: 'Dates & milk', nutrition: 'Calcium, Iron', calories: 210 },
          { meal: 'Dinner', food: 'Chicken fufu soup with vegetables', nutrition: 'Protein, Calcium, Vitamins', calories: 520 }
        ],
        Friday: [
          { meal: 'Breakfast', food: 'Fonio pilaf with vegetables & egg', nutrition: 'Complete protein, Iron', calories: 440 },
          { meal: 'Snack', food: 'Hibiscus juice & groundnut cookies', nutrition: 'Iron, Protein', calories: 210 },
          { meal: 'Lunch', food: 'Red stew with fish & yam', nutrition: 'Lycopene, Omega-3, Potassium', calories: 560 },
          { meal: 'Snack', food: 'Mango & almond milk', nutrition: 'Calcium, Vitamins', calories: 200 },
          { meal: 'Dinner', food: 'Beef with cassava leaves & rice', nutrition: 'Iron, Calcium, Protein', calories: 530 }
        ],
        Saturday: [
          { meal: 'Breakfast', food: 'Barley porridge with dried fruit', nutrition: 'Fiber, Iron, Minerals', calories: 420 },
          { meal: 'Snack', food: 'Yogurt with granola', nutrition: 'Calcium, Protein', calories: 220 },
          { meal: 'Lunch', food: 'Pumpkin soup with beans & bread', nutrition: 'Beta-carotene, Fiber, Protein', calories: 540 },
          { meal: 'Snack', food: 'Papaya & sesame seeds', nutrition: 'Folate, Calcium', calories: 190 },
          { meal: 'Dinner', food: 'Grilled tilapia with spinach & sweet potato', nutrition: 'Omega-3, Iron, Folate', calories: 510 }
        ],
        Sunday: [
          { meal: 'Breakfast', food: 'Jollof rice & eggs', nutrition: 'B vitamins, Protein', calories: 450 },
          { meal: 'Snack', food: 'Coconut milk with banana', nutrition: 'Healthy fats, Potassium', calories: 210 },
          { meal: 'Lunch', food: 'Egusi soup with fufu', nutrition: 'Protein, Calcium, Folate', calories: 560 },
          { meal: 'Snack', food: 'Roasted corn with groundnut paste', nutrition: 'Protein, Fiber', calories: 220 },
          { meal: 'Dinner', food: 'Beef stew with vegetables & millet', nutrition: 'Iron, B vitamins, Fiber', calories: 540 }
        ]
      }
    },
    3: {
      name: 'Third Trimester',
      note: 'Continue high calories, increase iron, prepare for labor',
      meals: {
        Monday: [
          { meal: 'Breakfast', food: 'Millet porridge with egg & fruit', nutrition: 'Energy, Protein, Folate', calories: 480 },
          { meal: 'Snack', food: 'Dates & milk shake', nutrition: 'Iron, Calcium, Energy', calories: 240 },
          { meal: 'Lunch', food: 'Red beans stew with plantain & chicken', nutrition: 'Iron, Protein, Carbs', calories: 600 },
          { meal: 'Snack', food: 'Avocado & whole grain crackers', nutrition: 'Healthy fats, Fiber', calories: 250 },
          { meal: 'Dinner', food: 'Fish curry with cassava & greens', nutrition: 'Omega-3, Iron, Calcium', calories: 580 }
        ],
        Tuesday: [
          { meal: 'Breakfast', food: 'Cassava porridge with egg & orange', nutrition: 'Carbs, Protein, Vitamin C', calories: 500 },
          { meal: 'Snack', food: 'Yogurt with honey & granola', nutrition: 'Calcium, Probiotics, Energy', calories: 260 },
          { meal: 'Lunch', food: 'Beef & pumpkin stew with millet', nutrition: 'Iron, Vitamin A, Carbs', calories: 610 },
          { meal: 'Snack', food: 'Mango & sesame paste', nutrition: 'Folate, Calcium', calories: 230 },
          { meal: 'Dinner', food: 'Okra soup with sardines & fufu', nutrition: 'Iron, Calcium, Omega-3', calories: 590 }
        ],
        Wednesday: [
          { meal: 'Breakfast', food: 'Sorghum pancakes with peanut sauce', nutrition: 'Protein, Energy, B vitamins', calories: 510 },
          { meal: 'Snack', food: 'Groundnuts & dried mango', nutrition: 'Protein, Iron', calories: 250 },
          { meal: 'Lunch', food: 'Lentil & kidney bean curry with rice', nutrition: 'Folate, Iron, Fiber', calories: 620 },
          { meal: 'Snack', food: 'Papaya & almond milk', nutrition: 'Folate, Calcium', calories: 240 },
          { meal: 'Dinner', food: 'Chicken with black-eyed peas & yam', nutrition: 'Protein, Iron, Potassium', calories: 600 }
        ],
        Thursday: [
          { meal: 'Breakfast', food: 'Fonio with eggs & vegetables', nutrition: 'Complete protein, Iron', calories: 500 },
          { meal: 'Snack', food: 'Banana & peanut butter', nutrition: 'Potassium, Protein, Energy', calories: 260 },
          { meal: 'Lunch', food: 'Beef stew with cassava leaves & rice', nutrition: 'Iron, Calcium, Folate', calories: 630 },
          { meal: 'Snack', food: 'Hibiscus juice & groundnut cookies', nutrition: 'Iron, Protein', calories: 240 },
          { meal: 'Dinner', food: 'Fish with spinach & sweet potato', nutrition: 'Omega-3, Iron, Folate', calories: 580 }
        ],
        Friday: [
          { meal: 'Breakfast', food: 'Barley porridge with dried fruit', nutrition: 'Fiber, Iron, Energy', calories: 490 },
          { meal: 'Snack', food: 'Dates with almonds & coconut milk', nutrition: 'Iron, Calcium, Healthy fats', calories: 270 },
          { meal: 'Lunch', food: 'Pumpkin soup with beans & chicken', nutrition: 'Beta-carotene, Protein, Fiber', calories: 610 },
          { meal: 'Snack', food: 'Watermelon with sesame seeds', nutrition: 'Hydration, Calcium', calories: 220 },
          { meal: 'Dinner', food: 'Red stew with beef & plantain', nutrition: 'Iron, Protein, Carbs', calories: 600 }
        ],
        Saturday: [
          { meal: 'Breakfast', food: 'Injera with lentils & egg', nutrition: 'Folate, Iron, Protein', calories: 520 },
          { meal: 'Snack', food: 'Avocado & yogurt', nutrition: 'Healthy fats, Calcium', calories: 250 },
          { meal: 'Lunch', food: 'Egusi soup with fufu & fish', nutrition: 'Protein, Calcium, Omega-3', calories: 620 },
          { meal: 'Snack', food: 'Roasted corn & groundnut', nutrition: 'Protein, B vitamins', calories: 260 },
          { meal: 'Dinner', food: 'Chicken with moringa stew & millet', nutrition: 'Iron, Calcium, Protein', calories: 610 }
        ],
        Sunday: [
          { meal: 'Breakfast', food: 'Jollof rice with egg & vegetables', nutrition: 'B vitamins, Protein, Folate', calories: 550 },
          { meal: 'Snack', food: 'Mango smoothie with milk', nutrition: 'Calcium, Vitamins, Energy', calories: 260 },
          { meal: 'Lunch', food: 'Bean soup with meat & vegetables', nutrition: 'Protein, Fiber, Iron', calories: 630 },
          { meal: 'Snack', food: 'Papaya & groundnut paste', nutrition: 'Folate, Protein, Energy', calories: 250 },
          { meal: 'Dinner', food: 'Fish stew with cassava & oil-palm greens', nutrition: 'Omega-3, Iron, Calcium', calories: 600 }
        ]
      }
    }
  }

  const days = ['Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday', 'Sunday']
  const currentMeals = africanMeals[selectedTrimester as 1|2|3].meals[selectedDay as keyof typeof africanMeals[1|2|3]['meals']]

  return (
    <div className="space-y-6">
      {/* Header */}
      <div className="bg-gradient-to-r from-hotpink to-hotpink-dark rounded-2xl p-8 text-white">
        <h1 className="text-4xl font-bold mb-2">African Meal Planner</h1>
        <p className="text-lg opacity-90">Nourishing you and baby with traditional African cuisine 🍽️</p>
      </div>

      {/* Trimester Selector */}
      <div className="bg-white rounded-xl border-2 border-hotpink-light p-6">
        <h2 className="text-xl font-bold text-hotpink mb-4">Select Your Trimester</h2>
        <div className="grid md:grid-cols-3 gap-4">
          {[1, 2, 3].map((tri) => (
            <button
              key={tri}
              onClick={() => setSelectedTrimester(tri)}
              className={`p-4 rounded-lg font-bold transition ${
                selectedTrimester === tri
                  ? 'bg-hotpink text-white'
                  : 'bg-white border-2 border-hotpink-light text-hotpink hover:bg-hotpink/10'
              }`}
            >
              {africanMeals[tri as 1|2|3].name}
            </button>
          ))}
        </div>
        <p className="text-gray-600 mt-4 text-sm italic">{africanMeals[selectedTrimester as 1|2|3].note}</p>
      </div>

      {/* Day Selector */}
      <div className="bg-white rounded-xl border-2 border-hotpink-light p-6">
        <h2 className="text-xl font-bold text-hotpink mb-4">Select a Day</h2>
        <div className="grid md:grid-cols-7 gap-2">
          {days.map((day) => (
            <button
              key={day}
              onClick={() => setSelectedDay(day)}
              className={`p-3 rounded-lg font-semibold transition text-sm ${
                selectedDay === day
                  ? 'bg-hotpink text-white'
                  : 'bg-hotpink/10 text-hotpink hover:bg-hotpink/20'
              }`}
            >
              {day.slice(0, 3)}
            </button>
          ))}
        </div>
      </div>

      {/* Meals for Selected Day */}
      <div className="space-y-4">
        {currentMeals && currentMeals.map((meal, idx) => (
          <div key={idx} className="bg-white rounded-xl border-2 border-hotpink-light p-6 hover:shadow-lg transition">
            <div className="flex items-start justify-between mb-3">
              <div>
                <p className="text-sm font-semibold text-hotpink">{meal.meal}</p>
                <h3 className="text-2xl font-bold text-darkbrown">{meal.food}</h3>
              </div>
              <div className="text-right">
                <p className="text-2xl font-bold text-terra">{meal.calories}</p>
                <p className="text-sm text-gray-600">calories</p>
              </div>
            </div>
            
            <div className="flex gap-4">
              <div className="flex-1 bg-gold/10 rounded-lg p-3">
                <p className="text-xs font-bold text-terra mb-1">NUTRITION INFO</p>
                <p className="text-sm text-gray-700">{meal.nutrition}</p>
              </div>
              <button className="bg-hotpink hover:bg-hotpink-dark text-white font-bold py-2 px-4 rounded-lg transition">
                Log Meal
              </button>
            </div>
          </div>
        ))}
      </div>

      {/* Nutrition Tips */}
      <div className="bg-gradient-to-r from-terra/10 to-terracotta/10 rounded-xl border-l-4 border-terra p-6">
        <h3 className="text-lg font-bold text-deepbrown mb-3 flex items-center gap-2">
          <span>🌾</span> African Nutrition Tips
        </h3>
        <ul className="space-y-2 text-gray-700">
          <li>✓ Millet, sorghum, and fonio are excellent sources of iron and fiber</li>
          <li>✓ Leafy greens (moringa, cassava leaves) provide calcium and folate</li>
          <li>✓ Groundnuts and sesame seeds offer healthy fats and protein</li>
          <li>✓ Traditional fermented foods aid digestion and provide probiotics</li>
          <li>✓ Ginger and hibiscus can help with nausea and iron absorption</li>
        </ul>
      </div>
    </div>
  )
}
