'use client'

import { useState } from 'react'

export default function BabyGrowthTracker() {
  const [selectedMonth, setSelectedMonth] = useState(0)

  const growthData = [
    {
      month: 0,
      age: 'Newborn',
      weight: '3.5 kg',
      length: '50 cm',
      illustration: '👶🏾',
      milestone: 'Ready for the world!',
      details: 'Your beautiful baby arrives ready to begin their journey',
      color: 'bg-red-100'
    },
    {
      month: 1,
      age: '1 Month',
      weight: '4.5 kg',
      length: '55 cm',
      illustration: '👶🏾',
      milestone: 'First Smiles',
      details: 'Baby begins to respond to your voice and show emotions',
      color: 'bg-orange-100'
    },
    {
      month: 3,
      age: '3 Months',
      weight: '6.2 kg',
      length: '61 cm',
      illustration: '🍼',
      milestone: 'Rolling Over',
      details: 'Baby develops stronger neck and back muscles',
      color: 'bg-yellow-100'
    },
    {
      month: 6,
      age: '6 Months',
      weight: '7.5 kg',
      length: '67 cm',
      illustration: '👶🏾',
      milestone: 'Six Month Wonder',
      details: 'Baby recognizes familiar faces and starts exploring',
      color: 'bg-green-100'
    },
    {
      month: 9,
      age: '9 Months',
      weight: '8.9 kg',
      length: '72 cm',
      illustration: '🚼',
      milestone: 'Near One Year',
      details: 'Baby may crawl or start pulling themselves up',
      color: 'bg-blue-100'
    },
    {
      month: 12,
      age: '1 Year',
      weight: '9.5 kg',
      length: '75 cm',
      illustration: '🎂',
      milestone: 'First Birthday!',
      details: 'Celebrate your baby\'s first year of growth and development',
      color: 'bg-pink-100'
    }
  ]

  return (
    <div className="bg-gradient-to-r from-hotpink/5 to-hotpink-light/5 p-8 rounded-xl border-2 border-hotpink-light">
      <h2 className="text-2xl font-bold text-hotpink mb-6">👶🏾 Baby Growth Tracker with African Illustrations</h2>
      
      {/* Growth Timeline */}
      <div className="mb-8 overflow-x-auto">
        <div className="flex gap-2 pb-4">
          {growthData.map((data, index) => (
            <button
              key={index}
              onClick={() => setSelectedMonth(index)}
              className={`px-4 py-2 rounded-lg font-semibold transition ${
                selectedMonth === index
                  ? 'bg-hotpink text-white shadow-lg'
                  : 'bg-hotpink/10 text-hotpink hover:bg-hotpink/20 border-2 border-hotpink-light'
              }`}
            >
              {data.age}
            </button>
          ))}
        </div>
      </div>

      {/* Selected Growth Card */}
      <div className={`${growthData[selectedMonth].color} rounded-xl p-8 shadow-lg border-2 border-hotpink-light`}>
        <div className="grid md:grid-cols-2 gap-8">
          {/* Illustration */}
          <div className="flex flex-col items-center justify-center">
            <div className="text-9xl mb-4">{growthData[selectedMonth].illustration}</div>
            <h3 className="text-2xl font-bold text-hotpink text-center">{growthData[selectedMonth].milestone}</h3>
          </div>

          {/* Details */}
          <div>
            <h3 className="text-3xl font-bold text-hotpink mb-4">{growthData[selectedMonth].age}</h3>
            
            <div className="space-y-4 mb-6">
              <div className="bg-white rounded-lg p-4 border-l-4 border-hotpink">
                <p className="text-gray-600 text-sm">Weight</p>
                <p className="text-2xl font-bold text-hotpink">{growthData[selectedMonth].weight}</p>
              </div>
              
              <div className="bg-white rounded-lg p-4 border-l-4 border-hotpink">
                <p className="text-gray-600 text-sm">Length</p>
                <p className="text-2xl font-bold text-hotpink">{growthData[selectedMonth].length}</p>
              </div>
            </div>

            <div className="bg-white rounded-lg p-4 border-l-4 border-gold">
              <p className="text-gray-600 text-sm mb-2">Development</p>
              <p className="text-gray-800">{growthData[selectedMonth].details}</p>
            </div>
          </div>
        </div>
      </div>

      {/* Growth Chart */}
      <div className="mt-12">
        <h3 className="text-xl font-bold text-hotpink mb-4">📈 Growth Progress</h3>
        <div className="bg-white rounded-lg p-6 border-2 border-hotpink-light">
          <div className="space-y-6">
            <div>
              <div className="flex justify-between items-center mb-2">
                <span className="text-sm font-semibold text-gray-700">Weight Gain</span>
                <span className="text-2xl font-bold text-orange-600">+6 kg</span>
              </div>
              <div className="w-full bg-gray-200 rounded-full h-3">
                <div className="bg-orange-500 h-3 rounded-full" style={{width: '63%'}}></div>
              </div>
            </div>

            <div>
              <div className="flex justify-between items-center mb-2">
                <span className="text-sm font-semibold text-gray-700">Height Growth</span>
                <span className="text-2xl font-bold text-green-600">+25 cm</span>
              </div>
              <div className="w-full bg-gray-200 rounded-full h-3">
                <div className="bg-green-500 h-3 rounded-full" style={{width: '83%'}}></div>
              </div>
            </div>

            <div>
              <div className="flex justify-between items-center mb-2">
                <span className="text-sm font-semibold text-gray-700">Development</span>
                <span className="text-2xl font-bold text-blue-600">12 months</span>
              </div>
              <div className="w-full bg-gray-200 rounded-full h-3">
                <div className="bg-blue-500 h-3 rounded-full" style={{width: '100%'}}></div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  )
}
