'use client'

import { useState } from 'react'

export default function BabyTrackerEnhancements() {
  const [selectedMonth, setSelectedMonth] = useState(0)

  const testimonials = [
    {
      id: 1,
      author: 'Mama Zainab',
      location: 'Lagos, Nigeria',
      text: 'This tracker helped me monitor my baby\'s growth perfectly! Every milestone has been so memorable.',
      avatar: '👩🏾‍🦱',
      baby: 'Kwame, 8 months'
    },
    {
      id: 2,
      author: 'Amara',
      location: 'Nairobi, Kenya',
      text: 'I love seeing my baby\'s progress visualized. It gives me so much confidence as a first-time mom!',
      avatar: '👩🏾‍🦱',
      baby: 'Zainab, 4 months'
    },
    {
      id: 3,
      author: 'Ada',
      location: 'Cape Town, RSA',
      text: 'The growth charts and milestones are so informative. Highly recommend to all mothers!',
      avatar: '👩🏾‍🦲',
      baby: 'Jamal, 6 months'
    }
  ]

  const quickTips = [
    {
      id: 1,
      icon: '📸',
      title: 'Monthly Photos',
      description: 'Take photos at the same time each month to capture growth visually'
    },
    {
      id: 2,
      icon: '📝',
      title: 'Record Milestones',
      description: 'Document first smile, laugh, words, and other special moments'
    },
    {
      id: 3,
      icon: '💪',
      title: 'Celebrate Progress',
      description: 'Celebrate every milestone, big or small - they all matter!'
    },
    {
      id: 4,
      icon: '🏥',
      title: 'Regular Check-ups',
      description: 'Keep all medical records and vaccination updates current'
    }
  ]

  const developmentFocuses = [
    {
      month: 'Newborn',
      focus: 'Bonding & Feeding',
      tips: ['Skin-to-skin contact', 'Feed on demand', 'Establish routine']
    },
    {
      month: '3 Months',
      focus: 'Motor Development',
      tips: ['Tummy time daily', 'Watch for smiles', 'Respond to sounds']
    },
    {
      month: '6 Months',
      focus: 'Sensory Exploration',
      tips: ['Introduce textures', 'Start solids', 'Encourage sitting']
    },
    {
      month: '9 Months',
      focus: 'Mobility & Speech',
      tips: ['Safe crawling space', 'Read together', 'Encourage babbling']
    },
    {
      month: '12 Months',
      focus: 'Independence',
      tips: ['Let them explore', 'Encourage play', 'Celebrate first year']
    }
  ]

  return (
    <div className="space-y-12">
      {/* Quick Tips */}
      <div>
        <h3 className="text-2xl font-bold text-earth mb-6">📋 Quick Baby Care Tips</h3>
        <div className="grid md:grid-cols-2 lg:grid-cols-4 gap-4">
          {quickTips.map((tip) => (
            <div key={tip.id} className="bg-gradient-to-br from-warm/10 to-sand/10 rounded-lg p-4 border border-sand/30 hover:shadow-lg transition">
              <div className="text-3xl mb-2">{tip.icon}</div>
              <h4 className="font-bold text-earth mb-2">{tip.title}</h4>
              <p className="text-sm text-gray-700">{tip.description}</p>
            </div>
          ))}
        </div>
      </div>

      {/* Development Focus by Month */}
      <div>
        <h3 className="text-2xl font-bold text-earth mb-6">🎯 Development Focus by Month</h3>
        <div className="grid md:grid-cols-2 lg:grid-cols-5 gap-4">
          {developmentFocuses.map((dev, idx) => (
            <div key={idx} className="bg-white rounded-lg p-4 border-2 border-sand hover:border-earth transition">
              <h4 className="font-bold text-earth mb-2">{dev.month}</h4>
              <p className="text-sm font-semibold text-orange-600 mb-3">{dev.focus}</p>
              <ul className="text-xs space-y-1 text-gray-700">
                {dev.tips.map((tip, tipIdx) => (
                  <li key={tipIdx}>✓ {tip}</li>
                ))}
              </ul>
            </div>
          ))}
        </div>
      </div>

      {/* Mother Testimonials */}
      <div>
        <h3 className="text-2xl font-bold text-earth mb-6">❤️ Mother Testimonials</h3>
        <div className="grid md:grid-cols-3 gap-6">
          {testimonials.map((testimonial) => (
            <div key={testimonial.id} className="bg-gradient-to-br from-sand/20 to-warm/20 rounded-xl p-6 border border-sand/40">
              <div className="flex items-center gap-4 mb-4">
                <div className="text-4xl">{testimonial.avatar}</div>
                <div>
                  <h4 className="font-bold text-earth">{testimonial.author}</h4>
                  <p className="text-sm text-gray-600">{testimonial.location}</p>
                </div>
              </div>
              <p className="text-gray-700 italic mb-3">"{testimonial.text}"</p>
              <p className="text-xs bg-white px-3 py-1 rounded-full inline-block text-earth font-semibold">{testimonial.baby}</p>
            </div>
          ))}
        </div>
      </div>

      {/* Growth Tracking Log */}
      <div>
        <h3 className="text-2xl font-bold text-earth mb-6">📊 Growth Tracking Log</h3>
        <div className="bg-white rounded-lg border border-sand/30 overflow-x-auto">
          <table className="w-full">
            <thead>
              <tr className="bg-earth/5 border-b border-sand/30">
                <th className="px-4 py-3 text-left font-bold text-earth">Age</th>
                <th className="px-4 py-3 text-left font-bold text-earth">Weight</th>
                <th className="px-4 py-3 text-left font-bold text-earth">Length</th>
                <th className="px-4 py-3 text-left font-bold text-earth">Head Circumference</th>
                <th className="px-4 py-3 text-left font-bold text-earth">Key Milestone</th>
              </tr>
            </thead>
            <tbody>
              {[
                { age: 'Newborn', weight: '3.5 kg', length: '50 cm', head: '35 cm', milestone: 'Birth' },
                { age: '1 Month', weight: '4.5 kg', length: '55 cm', head: '37 cm', milestone: 'First smile' },
                { age: '3 Months', weight: '6.2 kg', length: '61 cm', head: '40 cm', milestone: 'Rolling' },
                { age: '6 Months', weight: '7.5 kg', length: '67 cm', head: '43 cm', milestone: 'Sitting' },
                { age: '9 Months', weight: '8.9 kg', length: '72 cm', head: '45 cm', milestone: 'Crawling' },
                { age: '12 Months', weight: '9.5 kg', length: '75 cm', head: '46 cm', milestone: 'First steps' }
              ].map((row, idx) => (
                <tr key={idx} className="border-b border-sand/20 hover:bg-warm/5 transition">
                  <td className="px-4 py-3 font-semibold text-earth">{row.age}</td>
                  <td className="px-4 py-3 text-gray-700">{row.weight}</td>
                  <td className="px-4 py-3 text-gray-700">{row.length}</td>
                  <td className="px-4 py-3 text-gray-700">{row.head}</td>
                  <td className="px-4 py-3 text-orange-600 font-semibold">{row.milestone}</td>
                </tr>
              ))}
            </tbody>
          </table>
        </div>
      </div>

      {/* Vaccination Schedule */}
      <div>
        <h3 className="text-2xl font-bold text-earth mb-6">💉 Recommended Vaccination Schedule</h3>
        <div className="grid md:grid-cols-2 gap-6">
          <div className="bg-gradient-to-br from-green-50 to-forest/10 rounded-lg p-6 border border-forest/30">
            <h4 className="font-bold text-forest mb-4">First Year Vaccinations</h4>
            <ul className="space-y-2 text-sm">
              <li className="flex items-start gap-2">
                <span className="text-green-600 font-bold">✓</span>
                <span><strong>Birth:</strong> BCG, Polio (OPV)</span>
              </li>
              <li className="flex items-start gap-2">
                <span className="text-green-600 font-bold">✓</span>
                <span><strong>6 Weeks:</strong> Pentavalent 1, Polio 1, Rotavirus 1</span>
              </li>
              <li className="flex items-start gap-2">
                <span className="text-green-600 font-bold">✓</span>
                <span><strong>10 Weeks:</strong> Pentavalent 2, Polio 2, Rotavirus 2</span>
              </li>
              <li className="flex items-start gap-2">
                <span className="text-green-600 font-bold">✓</span>
                <span><strong>14 Weeks:</strong> Pentavalent 3, Polio 3, Rotavirus 3</span>
              </li>
              <li className="flex items-start gap-2">
                <span className="text-green-600 font-bold">✓</span>
                <span><strong>9 Months:</strong> Measles, Yellow Fever</span>
              </li>
            </ul>
          </div>

          <div className="bg-gradient-to-br from-blue-50 to-sky/10 rounded-lg p-6 border border-sky/30">
            <h4 className="font-bold text-blue-900 mb-4">Health Check Reminders</h4>
            <ul className="space-y-2 text-sm">
              <li className="flex items-start gap-2">
                <span className="text-blue-600 font-bold">📅</span>
                <span><strong>Monthly:</strong> Weight and length check</span>
              </li>
              <li className="flex items-start gap-2">
                <span className="text-blue-600 font-bold">📅</span>
                <span><strong>3 Months:</strong> Complete medical examination</span>
              </li>
              <li className="flex items-start gap-2">
                <span className="text-blue-600 font-bold">📅</span>
                <span><strong>6 Months:</strong> Developmental screening</span>
              </li>
              <li className="flex items-start gap-2">
                <span className="text-blue-600 font-bold">📅</span>
                <span><strong>12 Months:</strong> Full developmental assessment</span>
              </li>
              <li className="flex items-start gap-2">
                <span className="text-blue-600 font-bold">📅</span>
                <span><strong>As Needed:</strong> Consult for concerns</span>
              </li>
            </ul>
          </div>
        </div>
      </div>
    </div>
  )
}
