'use client'

import Link from 'next/link'
import { usePathname } from 'next/navigation'
import { useState, useEffect } from 'react'

export default function BottomNavigation() {
  const pathname = usePathname()
  const [mounted, setMounted] = useState(false)

  useEffect(() => {
    setMounted(true)
  }, [])

  const items = [
    { href: '/', label: 'Dashboard', icon: '📊' },
    { href: '/meals', label: 'Meals', icon: '🍽️' },
    { href: '/exercises', label: 'Exercises', icon: '💪' },
    { href: '/baby-growth', label: 'Baby', icon: '👶🏾' },
    { href: '/community', label: 'Community', icon: '👥' }
  ]

  if (!mounted) {
    return null
  }

  return (
    <nav className="fixed bottom-0 left-0 right-0 bg-hotpink-dark text-white border-t-2 border-hotpink shadow-2xl z-40">
      <div className="max-w-6xl mx-auto px-2">
        <div className="grid grid-cols-5 gap-1">
          {items.map((item) => {
            const isActive = pathname === item.href || pathname.startsWith(item.href + '/')
            return (
              <Link
                key={item.href}
                href={item.href}
                className={`flex flex-col items-center justify-center py-3 px-2 transition font-semibold text-sm ${
                  isActive
                    ? 'text-hotpink-light bg-black/20 border-t-2 border-gold'
                    : 'text-white hover:bg-white/10'
                }`}
              >
                <span className="text-2xl mb-0.5">{item.icon}</span>
                <span className="text-xs">{item.label}</span>
              </Link>
            )
          })}
        </div>
      </div>
    </nav>
  )
}
