'use client'

export default function CommunityAvatars() {
  const communityMembers = [
    {
      id: 1,
      name: 'Zainab M.',
      location: 'Lagos, Nigeria',
      avatar: '👩🏾‍🦱',
      color: 'bg-orange-400',
      status: 'Mother of 2',
      joinDate: 'Jan 2024'
    },
    {
      id: 2,
      name: 'Amara K.',
      location: 'Nairobi, Kenya',
      avatar: '👩🏾‍🦱',
      color: 'bg-yellow-400',
      status: 'Pregnant',
      joinDate: 'Feb 2024'
    },
    {
      id: 3,
      name: 'Ada N.',
      location: 'Cape Town, RSA',
      avatar: '👩🏾‍🦲',
      color: 'bg-amber-400',
      status: 'New Mom',
      joinDate: 'Mar 2024'
    },
    {
      id: 4,
      name: 'Fatima S.',
      location: 'Accra, Ghana',
      avatar: '👩🏾‍🦲',
      color: 'bg-red-400',
      status: 'Mother',
      joinDate: 'Jan 2024'
    },
    {
      id: 5,
      name: 'Simone L.',
      location: 'Luanda, Angola',
      avatar: '👩🏾‍🦱',
      color: 'bg-rose-400',
      status: 'Expecting',
      joinDate: 'Apr 2024'
    },
    {
      id: 6,
      name: 'Nia M.',
      location: 'Dar es Salaam, TZ',
      avatar: '👩🏾‍🦱',
      color: 'bg-pink-400',
      status: 'Mother',
      joinDate: 'Feb 2024'
    },
  ]

  return (
    <div className="bg-gradient-to-r from-hotpink/5 to-hotpink-light/5 p-8 rounded-xl border-2 border-hotpink-light">
      <h2 className="text-2xl font-bold text-hotpink mb-6">🌍 Meet Our African Community</h2>
      <div className="grid grid-cols-2 md:grid-cols-3 lg:grid-cols-6 gap-4">
        {communityMembers.map((member) => (
          <div key={member.id} className="text-center p-4 bg-white rounded-lg border-2 border-hotpink-light hover:border-hotpink hover:shadow-lg transition">
            <div className={`${member.color} community-avatar mx-auto mb-3 shadow-lg`}>
              <span className="text-3xl">{member.avatar}</span>
            </div>
            <h4 className="font-semibold text-sm text-deepbrown">{member.name}</h4>
            <p className="text-xs text-gray-600">{member.location}</p>
            <p className="text-xs bg-hotpink/20 text-hotpink px-2 py-1 rounded mt-2 font-semibold">{member.status}</p>
          </div>
        ))}
      </div>
    </div>
  )
}
