'use client'

import { useState } from 'react'

export default function CommunityEnhancements() {
  const [activeTab, setActiveTab] = useState('spotlights')

  const memberSpotlights = [
    {
      id: 1,
      name: 'Mama Zainab',
      location: 'Lagos, Nigeria',
      role: 'Community Expert - 2 years',
      avatar: '👩🏾‍🦱',
      story: 'Supported 150+ first-time mothers through pregnancy journey. Now mentoring new members!',
      posts: 342,
      helpfulVotes: 1245
    },
    {
      id: 2,
      name: 'Amara K.',
      location: 'Nairobi, Kenya',
      role: 'New Mom - Recently Joined',
      avatar: '👩🏾‍🦲',
      story: 'Just celebrated baby\'s first birthday. Grateful for the community\'s support throughout my journey.',
      posts: 45,
      helpfulVotes: 189
    },
    {
      id: 3,
      name: 'Ada',
      location: 'Cape Town, RSA',
      role: 'Health Professional',
      avatar: '👩🏾‍⚕️',
      story: 'Pediatrician and mother. Sharing medical insights while supporting fellow mothers daily.',
      posts: 256,
      helpfulVotes: 2103
    }
  ]

  const successStories = [
    {
      id: 1,
      title: 'From Worry to Confidence',
      author: 'Fatima S., Ghana',
      excerpt: 'I joined while 7 months pregnant, anxious about labor. The community held my hand through everything. Now mother of beautiful twins!',
      avatar: '👩🏾‍🦱',
      date: 'Feb 2024'
    },
    {
      id: 2,
      title: 'Postpartum Recovery Journey',
      author: 'Simone L., Angola',
      excerpt: 'Learning about postpartum care from experienced mothers made all the difference. My recovery was smooth and I felt supported every step.',
      avatar: '👩🏾‍🦲',
      date: 'Jan 2024'
    },
    {
      id: 3,
      title: 'Building Friendships',
      author: 'Nia M., Tanzania',
      excerpt: 'Met 5 amazing mothers in my local support group through this platform. We still meet weekly. Best decision ever!',
      avatar: '👩🏾‍🦱',
      date: 'Dec 2023'
    },
    {
      id: 4,
      title: 'Breastfeeding Success',
      author: 'Zara K., Kenya',
      excerpt: 'Struggled with breastfeeding initially. Expert tips from community members helped me persevere. Now nursing my 8-month-old easily!',
      avatar: '👩🏾‍🦲',
      date: 'Nov 2023'
    }
  ]

  const upcomingEvents = [
    {
      id: 1,
      title: 'Virtual Prenatal Workshop',
      date: 'Feb 15, 2024',
      time: '7:00 PM WAT',
      speaker: 'Dr. Amina Ahmed',
      topic: 'Labor & Delivery Preparation',
      attendees: 324,
      icon: '📺'
    },
    {
      id: 2,
      title: 'Local Meetup - Lagos',
      date: 'Feb 18, 2024',
      time: '2:00 PM WAT',
      speaker: 'Community Leads',
      topic: 'Baby Care Practical Session',
      attendees: 67,
      icon: '🤝'
    },
    {
      id: 3,
      title: 'Breastfeeding Support Circle',
      date: 'Feb 22, 2024',
      time: '6:00 PM EAT',
      speaker: 'Lactation Consultant',
      topic: 'Solving Common Challenges',
      attendees: 156,
      icon: '🍼'
    },
    {
      id: 4,
      title: 'Postpartum Mental Health',
      date: 'Feb 25, 2024',
      time: '3:00 PM SAST',
      speaker: 'Mental Health Professional',
      topic: 'Self-Care & Support Resources',
      attendees: 203,
      icon: '💭'
    }
  ]

  const topicsFAQ = [
    {
      id: 1,
      title: 'Pregnancy Health',
      discussions: 2345,
      members: 8934,
      recent: '5 hours ago',
      icon: '🤰'
    },
    {
      id: 2,
      title: 'Baby Care',
      discussions: 1876,
      members: 7654,
      recent: '2 hours ago',
      icon: '👶'
    },
    {
      id: 3,
      title: 'Nutrition & Fitness',
      discussions: 1243,
      members: 5432,
      recent: '45 mins ago',
      icon: '🥗'
    },
    {
      id: 4,
      title: 'Mental Health & Wellness',
      discussions: 987,
      members: 4321,
      recent: '1 hour ago',
      icon: '🧘'
    },
    {
      id: 5,
      title: 'Work & Balance',
      discussions: 654,
      members: 2876,
      recent: '8 hours ago',
      icon: '⚖️'
    },
    {
      id: 6,
      title: 'Partner & Family',
      discussions: 543,
      members: 2345,
      recent: '3 hours ago',
      icon: '👨‍👩‍👧'
    }
  ]

  return (
    <div className="space-y-12">
      {/* Navigation Tabs */}
      <div>
        <div className="flex gap-2 border-b-2 border-sand/30 overflow-x-auto">
          {[
            { key: 'spotlights', label: '⭐ Member Spotlights' },
            { key: 'stories', label: '📖 Success Stories' },
            { key: 'events', label: '📅 Upcoming Events' },
            { key: 'topics', label: '💬 Discussion Topics' }
          ].map((tab) => (
            <button
              key={tab.key}
              onClick={() => setActiveTab(tab.key)}
              className={`px-6 py-3 font-semibold transition whitespace-nowrap ${
                activeTab === tab.key
                  ? 'text-earth border-b-4 border-earth'
                  : 'text-gray-600 hover:text-earth'
              }`}
            >
              {tab.label}
            </button>
          ))}
        </div>
      </div>

      {/* Member Spotlights */}
      {activeTab === 'spotlights' && (
        <div>
          <h3 className="text-2xl font-bold text-earth mb-6">⭐ Featured Community Members</h3>
          <div className="grid md:grid-cols-3 gap-6">
            {memberSpotlights.map((member) => (
              <div key={member.id} className="bg-gradient-to-br from-warm/10 to-sand/10 rounded-xl p-6 border border-sand/40 hover:shadow-lg transition">
                <div className="flex items-center gap-3 mb-4">
                  <div className="text-5xl">{member.avatar}</div>
                  <div>
                    <h4 className="font-bold text-earth text-lg">{member.name}</h4>
                    <p className="text-xs text-gray-600">{member.location}</p>
                  </div>
                </div>
                
                <div className="mb-3 px-3 py-1 bg-orange-100 rounded-full inline-block">
                  <p className="text-xs font-semibold text-orange-700">{member.role}</p>
                </div>
                
                <p className="text-gray-700 mb-4 min-h-[60px]">{member.story}</p>
                
                <div className="flex gap-4 pt-4 border-t border-sand/30">
                  <div className="text-center flex-1">
                    <p className="text-lg font-bold text-earth">{member.posts}</p>
                    <p className="text-xs text-gray-600">Posts</p>
                  </div>
                  <div className="text-center flex-1">
                    <p className="text-lg font-bold text-orange-600">{member.helpfulVotes}</p>
                    <p className="text-xs text-gray-600">Helpful Votes</p>
                  </div>
                </div>
                
                <button className="w-full mt-4 bg-earth hover:bg-orange-700 text-white font-semibold py-2 rounded transition">
                  View Profile
                </button>
              </div>
            ))}
          </div>
        </div>
      )}

      {/* Success Stories */}
      {activeTab === 'stories' && (
        <div>
          <h3 className="text-2xl font-bold text-earth mb-6">📖 Inspiring Success Stories</h3>
          <div className="grid md:grid-cols-2 gap-6">
            {successStories.map((story) => (
              <div key={story.id} className="bg-white rounded-lg border-l-4 border-earth p-6 hover:shadow-lg transition">
                <div className="flex items-start justify-between mb-3">
                  <div className="flex items-center gap-3">
                    <div className="text-3xl">{story.avatar}</div>
                    <div>
                      <p className="font-bold text-earth">{story.author}</p>
                      <p className="text-xs text-gray-500">{story.date}</p>
                    </div>
                  </div>
                </div>
                
                <h4 className="text-lg font-bold text-earth mb-2">{story.title}</h4>
                <p className="text-gray-700 text-sm leading-relaxed italic">"{story.excerpt}"</p>
                
                <button className="mt-4 text-earth font-semibold hover:text-orange-600 transition">
                  Read Full Story →
                </button>
              </div>
            ))}
          </div>
        </div>
      )}

      {/* Upcoming Events */}
      {activeTab === 'events' && (
        <div>
          <h3 className="text-2xl font-bold text-earth mb-6">📅 Upcoming Community Events</h3>
          <div className="space-y-4">
            {upcomingEvents.map((event) => (
              <div key={event.id} className="bg-white rounded-lg border border-sand/30 p-6 hover:shadow-md transition">
                <div className="flex items-start justify-between gap-4">
                  <div className="flex items-start gap-4 flex-1">
                    <div className="text-4xl">{event.icon}</div>
                    <div className="flex-1">
                      <h4 className="text-lg font-bold text-earth mb-1">{event.title}</h4>
                      <p className="text-sm text-orange-600 font-semibold mb-2">{event.topic}</p>
                      
                      <div className="grid grid-cols-2 gap-3 text-sm text-gray-700">
                        <div>📅 {event.date}</div>
                        <div>🕐 {event.time}</div>
                        <div>👨‍🏫 {event.speaker}</div>
                        <div>👥 {event.attendees} attending</div>
                      </div>
                    </div>
                  </div>
                  
                  <button className="bg-earth hover:bg-orange-700 text-white font-semibold py-2 px-6 rounded transition whitespace-nowrap">
                    RSVP
                  </button>
                </div>
              </div>
            ))}
          </div>
        </div>
      )}

      {/* Discussion Topics */}
      {activeTab === 'topics' && (
        <div>
          <h3 className="text-2xl font-bold text-earth mb-6">💬 Popular Discussion Topics</h3>
          <div className="grid md:grid-cols-2 lg:grid-cols-3 gap-4">
            {topicsFAQ.map((topic) => (
              <div key={topic.id} className="bg-white rounded-lg border border-sand/30 p-6 hover:shadow-lg transition cursor-pointer group">
                <div className="text-5xl mb-3">{topic.icon}</div>
                
                <h4 className="text-lg font-bold text-earth mb-4 group-hover:text-orange-600 transition">
                  {topic.title}
                </h4>
                
                <div className="space-y-2 text-sm text-gray-700">
                  <div className="flex items-center gap-2">
                    <span className="text-orange-500">💬</span>
                    <span><strong>{topic.discussions}</strong> discussions</span>
                  </div>
                  <div className="flex items-center gap-2">
                    <span className="text-blue-500">👥</span>
                    <span><strong>{topic.members}</strong> members</span>
                  </div>
                  <div className="flex items-center gap-2">
                    <span className="text-gray-500">🕐</span>
                    <span>Active <strong>{topic.recent}</strong></span>
                  </div>
                </div>
                
                <button className="w-full mt-4 bg-sand/20 hover:bg-sand/40 text-earth font-semibold py-2 rounded transition">
                  Join Discussion
                </button>
              </div>
            ))}
          </div>
        </div>
      )}

      {/* Community Guidelines */}
      <div className="bg-gradient-to-r from-forest/10 to-earth/10 rounded-lg p-8 border border-forest/20">
        <h3 className="text-2xl font-bold text-earth mb-6">🤝 Community Values & Guidelines</h3>
        
        <div className="grid md:grid-cols-2 gap-6">
          <div>
            <h4 className="font-bold text-earth mb-4 flex items-center gap-2">
              <span>✨</span> Our Values
            </h4>
            <ul className="space-y-3 text-gray-700">
              <li className="flex gap-2">
                <span className="text-green-600 font-bold">✓</span>
                <span><strong>Respect:</strong> All mothers' experiences are valid</span>
              </li>
              <li className="flex gap-2">
                <span className="text-green-600 font-bold">✓</span>
                <span><strong>Support:</strong> Lift each other up through challenges</span>
              </li>
              <li className="flex gap-2">
                <span className="text-green-600 font-bold">✓</span>
                <span><strong>Authenticity:</strong> Be genuine and honest</span>
              </li>
              <li className="flex gap-2">
                <span className="text-green-600 font-bold">✓</span>
                <span><strong>Safety:</strong> Protect each other's privacy</span>
              </li>
            </ul>
          </div>
          
          <div>
            <h4 className="font-bold text-earth mb-4 flex items-center gap-2">
              <span>📋</span> Key Guidelines
            </h4>
            <ul className="space-y-3 text-gray-700">
              <li className="flex gap-2">
                <span className="text-blue-600 font-bold">→</span>
                <span>No judgment - we all parent differently</span>
              </li>
              <li className="flex gap-2">
                <span className="text-blue-600 font-bold">→</span>
                <span>Share experiences, not medical advice*</span>
              </li>
              <li className="flex gap-2">
                <span className="text-blue-600 font-bold">→</span>
                <span>Celebrate diversity and different choices</span>
              </li>
              <li className="flex gap-2">
                <span className="text-blue-600 font-bold">→</span>
                <span>Report concerns to community moderators</span>
              </li>
            </ul>
          </div>
        </div>
        
        <p className="text-xs text-gray-600 mt-6 italic">
          *Medical advice should always be discussed with healthcare professionals. Community members share personal experiences, not professional medical guidance.
        </p>
      </div>
    </div>
  )
}
