'use client'

export default function CommunityHighlights() {
  const highlights = [
    {
      id: 1,
      title: 'Support Groups Active',
      count: '145+',
      icon: '👥',
      description: 'Communities across Africa',
      color: 'bg-orange-100'
    },
    {
      id: 2,
      title: 'Mothers Connected',
      count: '12,450+',
      icon: '🤝',
      description: 'Supporting each other daily',
      color: 'bg-yellow-100'
    },
    {
      id: 3,
      title: 'Success Stories',
      count: '3,890+',
      icon: '📖',
      description: 'Inspiring journeys shared',
      color: 'bg-red-100'
    },
    {
      id: 4,
      title: 'Expert Consultations',
      count: '8,560+',
      icon: '👨‍⚕️',
      description: 'Healthcare professionals available',
      color: 'bg-green-100'
    }
  ]

  return (
    <section className="py-12 px-4 bg-gradient-to-r from-hotpink/10 to-hotpink-light/10">
      <div className="max-w-6xl mx-auto">
        <h2 className="text-3xl font-bold text-center mb-2 text-hotpink">Community Highlights</h2>
        <p className="text-center text-gray-600 mb-8">Join thousands of mothers across Africa in our thriving community</p>
        
        <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-4">
          {highlights.map((highlight) => (
            <div key={highlight.id} className={`${highlight.color} rounded-lg p-6 text-center hover:shadow-lg transition border-2 border-hotpink-light`}>
              <div className="text-5xl mb-3">{highlight.icon}</div>
              <h3 className="text-2xl font-bold text-hotpink mb-1">{highlight.count}</h3>
              <p className="font-semibold text-gray-800 mb-1">{highlight.title}</p>
              <p className="text-sm text-gray-600">{highlight.description}</p>
            </div>
          ))}
        </div>

        <div className="mt-8 text-center">
          <button className="bg-earth hover:bg-orange-700 text-white font-bold py-3 px-8 rounded-lg transition">
            Join Our Community
          </button>
        </div>
      </div>
    </section>
  )
}
