'use client'

export default function CommunityStats() {
  const stats = [
    {
      id: 1,
      label: 'Active Discussions',
      value: '2,340',
      trend: '↑ +125 this week',
      color: 'bg-orange-100',
      icon: '💬'
    },
    {
      id: 2,
      label: 'Helpful Posts',
      value: '8,765',
      trend: '↑ +342 this week',
      color: 'bg-yellow-100',
      icon: '📝'
    },
    {
      id: 3,
      label: 'Resource Guides',
      value: '156',
      trend: '↑ +8 new guides',
      color: 'bg-red-100',
      icon: '📚'
    },
    {
      id: 4,
      label: 'Expert Answers',
      value: '4,230',
      trend: '↑ Average 2hrs response',
      color: 'bg-green-100',
      icon: '✓'
    },
    {
      id: 5,
      label: 'Success Milestones',
      value: '3,456',
      trend: '↑ Celebrating births',
      color: 'bg-pink-100',
      icon: '🎉'
    },
    {
      id: 6,
      label: 'Member Rating',
      value: '4.9/5',
      trend: '★★★★★',
      color: 'bg-purple-100',
      icon: '⭐'
    }
  ]

  return (
    <div className="bg-gradient-to-r from-hotpink/5 to-hotpink-light/5 p-8 rounded-xl border-2 border-hotpink-light">
      <h2 className="text-2xl font-bold text-hotpink mb-6">📊 Community Statistics</h2>
      <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-4">
        {stats.map((stat) => (
          <div key={stat.id} className={`stat-card ${stat.color} border-2 border-hotpink-light hover:border-hotpink hover:shadow-lg transition`}>
            <div className="flex items-start justify-between">
              <div className="flex-1">
                <p className="text-gray-600 text-sm mb-1">{stat.label}</p>
                <p className="text-3xl font-bold text-hotpink mb-2">{stat.value}</p>
                <p className="text-xs text-gray-500">{stat.trend}</p>
              </div>
              <span className="text-3xl">{stat.icon}</span>
            </div>
          </div>
        ))}
      </div>
    </div>
  )
}
