'use client'

import { useState } from 'react'

export default function Dashboard() {
  const [pregnancyWeek, setPregnancyWeek] = useState(22)
  const [dueDate] = useState(new Date(Date.now() + 18 * 7 * 24 * 60 * 60 * 1000))
  
  const babySize = [
    { week: '8-12', size: 'Almond', cm: '2.5-5 cm' },
    { week: '16', size: 'Avocado', cm: '11 cm' },
    { week: '20', size: 'Mango', cm: '16 cm' },
    { week: '24', size: 'Papaya', cm: '30 cm' },
    { week: '28', size: 'Eggplant', cm: '37 cm' },
    { week: '32', size: 'Pineapple', cm: '42 cm' },
    { week: '36', size: 'Cantaloupe', cm: '47 cm' },
    { week: '40', size: 'Watermelon', cm: '50 cm' },
  ]

  const currentBabyInfo = babySize.find(b => parseInt(b.week.split('-')[0]) <= pregnancyWeek && parseInt(b.week.split('-')[1] || b.week) >= pregnancyWeek)

  const trimsesterInfo = {
    1: { name: 'First', months: '1-3', color: 'from-red-100 to-orange-100' },
    2: { name: 'Second', months: '4-6', color: 'from-yellow-100 to-amber-100' },
    3: { name: 'Third', months: '7-9', color: 'from-green-100 to-teal-100' }
  }

  const getTrimester = () => {
    if (pregnancyWeek <= 13) return 1
    if (pregnancyWeek <= 26) return 2
    return 3
  }

  const daysUntilDue = Math.ceil((dueDate.getTime() - Date.now()) / (1000 * 60 * 60 * 24))

  return (
    <div className="space-y-6">
      {/* Header Card */}
      <div className="bg-gradient-to-r from-hotpink to-hotpink-dark rounded-2xl p-8 text-white">
        <h1 className="text-4xl font-bold mb-2">Your Pregnancy Journey</h1>
        <p className="text-lg opacity-90">Welcome back, Mama! Let's celebrate your growing baby 💕</p>
      </div>

      {/* Quick Stats Grid */}
      <div className="grid md:grid-cols-3 gap-4">
        {/* Week Counter */}
        <div className="bg-white rounded-xl border-2 border-hotpink-light p-6 text-center">
          <p className="text-gray-600 text-sm mb-2">You're Currently At</p>
          <p className="text-5xl font-bold text-hotpink mb-2">{pregnancyWeek}</p>
          <p className="text-gray-700 font-semibold">Weeks Pregnant</p>
          <button className="mt-4 w-full bg-hotpink text-white py-2 rounded-lg hover:bg-hotpink-dark transition">
            Update Week
          </button>
        </div>

        {/* Due Date Countdown */}
        <div className="bg-white rounded-xl border-2 border-hotpink-light p-6 text-center">
          <p className="text-gray-600 text-sm mb-2">Your Due Date</p>
          <p className="text-3xl font-bold text-hotpink mb-2">{dueDate.toLocaleDateString()}</p>
          <p className="text-2xl font-bold text-terra">{daysUntilDue} Days</p>
          <p className="text-gray-700 text-sm mt-2">until you meet baby!</p>
        </div>

        {/* Trimester Info */}
        <div className={`bg-gradient-to-br ${trimsesterInfo[getTrimester() as 1|2|3].color} rounded-xl border-2 border-hotpink-light p-6 text-center`}>
          <p className="text-gray-600 text-sm mb-2">Current Trimester</p>
          <p className="text-4xl font-bold text-deepbrown mb-2">{trimsesterInfo[getTrimester() as 1|2|3].name}</p>
          <p className="text-gray-700">Months {trimsesterInfo[getTrimester() as 1|2|3].months}</p>
        </div>
      </div>

      {/* Baby Size Card */}
      <div className="bg-white rounded-xl border-2 border-hotpink-light p-8">
        <h2 className="text-2xl font-bold text-hotpink mb-6 flex items-center gap-2">
          <span>👶🏾</span> Your Baby's Size
        </h2>
        
        <div className="grid md:grid-cols-2 gap-6">
          <div>
            <p className="text-gray-600 mb-2">This Week Your Baby Is About The Size Of:</p>
            <div className="bg-gradient-to-r from-hotpink/10 to-hotpink-light/10 rounded-lg p-6 text-center border-2 border-hotpink-light">
              <p className="text-5xl mb-3">{currentBabyInfo?.size === 'Almond' ? '🌰' : '🍎'}</p>
              <p className="text-3xl font-bold text-hotpink mb-2">{currentBabyInfo?.size}</p>
              <p className="text-gray-700 font-semibold">{currentBabyInfo?.cm}</p>
            </div>
          </div>

          <div>
            <p className="text-gray-600 mb-2">Baby Development This Week:</p>
            <div className="space-y-2">
              <div className="bg-green-50 border-l-4 border-green-500 p-3 rounded">
                <p className="font-semibold text-green-900">✨ Movement</p>
                <p className="text-sm text-green-800">You should feel regular kicks and movements</p>
              </div>
              <div className="bg-blue-50 border-l-4 border-blue-500 p-3 rounded">
                <p className="font-semibold text-blue-900">👁️ Vision</p>
                <p className="text-sm text-blue-800">Baby's eyes are now sensitive to light</p>
              </div>
              <div className="bg-purple-50 border-l-4 border-purple-500 p-3 rounded">
                <p className="font-semibold text-purple-900">🧠 Brain</p>
                <p className="text-sm text-purple-800">Brain development is accelerating rapidly</p>
              </div>
            </div>
          </div>
        </div>
      </div>

      {/* Today's Essentials */}
      <div className="bg-white rounded-xl border-2 border-hotpink-light p-8">
        <h2 className="text-2xl font-bold text-hotpink mb-6">Today's Essentials</h2>
        
        <div className="grid md:grid-cols-4 gap-4">
          <div className="bg-gradient-to-br from-hotpink/5 to-hotpink-light/5 rounded-lg p-4 border border-hotpink-light text-center hover:shadow-lg transition cursor-pointer">
            <div className="text-4xl mb-2">💧</div>
            <p className="font-bold text-gray-800">Stay Hydrated</p>
            <p className="text-sm text-gray-600">8-10 glasses daily</p>
          </div>

          <div className="bg-gradient-to-br from-gold/20 to-terra/20 rounded-lg p-4 border border-gold/50 text-center hover:shadow-lg transition cursor-pointer">
            <div className="text-4xl mb-2">🍎</div>
            <p className="font-bold text-gray-800">Healthy Eating</p>
            <p className="text-sm text-gray-600">Nutritious meals</p>
          </div>

          <div className="bg-gradient-to-br from-green-100/50 to-emerald-100/50 rounded-lg p-4 border border-green-200 text-center hover:shadow-lg transition cursor-pointer">
            <div className="text-4xl mb-2">🧘‍♀️</div>
            <p className="font-bold text-gray-800">Gentle Exercise</p>
            <p className="text-sm text-gray-600">30 min walks</p>
          </div>

          <div className="bg-gradient-to-br from-blue-100/50 to-cyan-100/50 rounded-lg p-4 border border-blue-200 text-center hover:shadow-lg transition cursor-pointer">
            <div className="text-4xl mb-2">😴</div>
            <p className="font-bold text-gray-800">Restful Sleep</p>
            <p className="text-sm text-gray-600">8-10 hours</p>
          </div>
        </div>
      </div>

      {/* Weekly Pregnancy Tip */}
      <div className="bg-gradient-to-r from-terra/10 to-terracotta/10 rounded-xl border-l-4 border-terra p-6">
        <h3 className="text-lg font-bold text-deepbrown mb-2 flex items-center gap-2">
          <span>💡</span> African Wisdom This Week
        </h3>
        <p className="text-gray-700 italic">
          "In African tradition, pregnancy is seen as a time of heightened intuition. Trust your body, listen to your mother's advice, and connect with other women in your community. Your body knows what to do." - Traditional Birth Wisdom
        </p>
      </div>

      {/* Recent Activity */}
      <div className="bg-white rounded-xl border-2 border-hotpink-light p-8">
        <h2 className="text-2xl font-bold text-hotpink mb-6">Your Progress</h2>
        
        <div className="space-y-3">
          <div className="flex items-center justify-between p-3 bg-hotpink/5 rounded-lg">
            <span className="flex items-center gap-2">
              <span className="text-2xl">🤰🏾</span>
              <span className="font-semibold">Week 22 Update</span>
            </span>
            <span className="text-sm text-gray-600">Today</span>
          </div>
          <div className="flex items-center justify-between p-3 bg-gold/10 rounded-lg">
            <span className="flex items-center gap-2">
              <span className="text-2xl">🥗</span>
              <span className="font-semibold">Meal logged</span>
            </span>
            <span className="text-sm text-gray-600">Yesterday</span>
          </div>
          <div className="flex items-center justify-between p-3 bg-green-100/30 rounded-lg">
            <span className="flex items-center gap-2">
              <span className="text-2xl">🧘‍♀️</span>
              <span className="font-semibold">Exercise completed</span>
            </span>
            <span className="text-sm text-gray-600">2 days ago</span>
          </div>
        </div>
      </div>
    </div>
  )
}
