'use client'

export default function Footer() {
  return (
    <footer className="bg-hotpink-dark text-white py-12 px-4">
      <div className="max-w-6xl mx-auto">
        <div className="grid grid-cols-1 md:grid-cols-4 gap-8 mb-8">
          <div>
            <h4 className="text-lg font-bold mb-4 flex items-center gap-2">🤰🏾 MamaHub African</h4>
            <p className="text-hotpink-light">Supporting mothers across Africa through every step of their pregnancy and motherhood journey.</p>
          </div>
          
          <div>
            <h4 className="text-lg font-bold mb-4">Quick Links</h4>
            <ul className="space-y-2 text-hotpink-light">
              <li><a href="/" className="hover:text-gold transition">Home</a></li>
              <li><a href="/milestones" className="hover:text-gold transition">Milestones</a></li>
              <li><a href="/baby-tracker" className="hover:text-gold transition">Baby Tracker</a></li>
              <li><a href="/community" className="hover:text-gold transition">Community</a></li>
            </ul>
          </div>
          
          <div>
            <h4 className="text-lg font-bold mb-4">Resources</h4>
            <ul className="space-y-2 text-hotpink-light">
              <li><a href="/tips" className="hover:text-gold transition">Health Tips</a></li>
              <li><a href="/meals" className="hover:text-gold transition">Meal Plans</a></li>
              <li><a href="/exercises" className="hover:text-gold transition">Exercises</a></li>
              <li><a href="/symptoms" className="hover:text-gold transition">Symptoms</a></li>
            </ul>
          </div>
          
          <div>
            <h4 className="text-lg font-bold mb-4">Connect</h4>
            <ul className="space-y-2 text-hotpink-light">
              <li><a href="#" className="hover:text-gold transition">Facebook</a></li>
              <li><a href="#" className="hover:text-gold transition">Instagram</a></li>
              <li><a href="#" className="hover:text-gold transition">Twitter</a></li>
              <li><a href="#" className="hover:text-gold transition">WhatsApp</a></li>
            </ul>
          </div>
        </div>
        
        <div className="border-t border-hotpink/30 pt-8 text-center text-hotpink-light">
          <p>&copy; 2026 MamaHub African. Supporting mothers across Africa. All rights reserved.</p>
          <div className="mt-4 flex justify-center gap-4 text-sm">
            <a href="#" className="hover:text-gold transition">Privacy Policy</a>
            <span>•</span>
            <a href="#" className="hover:text-gold transition">Terms of Service</a>
            <span>•</span>
            <a href="#" className="hover:text-white transition">Contact Us</a>
          </div>
        </div>
      </div>
    </footer>
  )
}
