'use client'

export default function MotherInspirationCards() {
  const inspirations = [
    {
      id: 1,
      name: 'Mama Zainab',
      origin: 'Nigeria',
      story: 'A strong mother of three who balanced her career while raising healthy, happy children. Her wisdom has inspired thousands.',
      image: '👩🏾‍🦱',
      specialty: 'Work-Life Balance'
    },
    {
      id: 2,
      name: 'Amara',
      origin: 'Kenya',
      story: 'First-time mother who created a beautiful support network for pregnant women in her community.',
      image: '👩🏾‍🤝‍👨🏾',
      specialty: 'Community Building'
    },
    {
      id: 3,
      name: 'Mama Adeyemi',
      origin: 'South Africa',
      story: 'Overcame challenges during pregnancy and became a prenatal health advocate, helping hundreds of women.',
      image: '👩🏾‍⚕️',
      specialty: 'Health Advocacy'
    },
    {
      id: 4,
      name: 'Okothee',
      origin: 'Uganda',
      story: 'A natural healer who combines traditional wisdom with modern healthcare for optimal pregnancy care.',
      image: '🌿',
      specialty: 'Holistic Wellness'
    },
    {
      id: 5,
      name: 'Mama Nia',
      origin: 'Tanzania',
      story: 'Entrepreneur and mother who inspires women to chase their dreams while nurturing their families.',
      image: '💼',
      specialty: 'Entrepreneurship'
    },
    {
      id: 6,
      name: 'Afia',
      origin: 'Ghana',
      story: 'Artist and creative mama who celebrates African motherhood through beautiful storytelling and art.',
      image: '🎨',
      specialty: 'Creative Expression'
    }
  ]

  return (
    <section className="py-12 px-4 bg-gradient-to-r from-hotpink/10 to-hotpink-light/10">
      <div className="max-w-6xl mx-auto">
        <h2 className="text-3xl font-bold text-center mb-2 text-hotpink">African Mother Inspiration Cards</h2>
        <p className="text-center text-gray-600 mb-8">Stories of strength, wisdom, and beautiful motherhood across the continent</p>
        
        <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
          {inspirations.map((inspiration) => (
            <div key={inspiration.id} className="inspiration-card border-2 border-hotpink-light hover:shadow-xl transition hover:border-hotpink">
              <div className="flex items-center gap-3 mb-4">
                <span className="text-4xl">{inspiration.image}</span>
                <div>
                  <h3 className="font-bold text-lg text-hotpink">{inspiration.name}</h3>
                  <p className="text-sm text-gray-500">{inspiration.origin}</p>
                </div>
              </div>
              
              <div className="mb-3">
                <span className="inline-block bg-hotpink/20 text-hotpink text-xs font-semibold px-3 py-1 rounded-full">
                  {inspiration.specialty}
                </span>
              </div>
              
              <p className="text-gray-700 text-sm leading-relaxed">{inspiration.story}</p>
            </div>
          ))}
        </div>
      </div>
    </section>
  )
}
