'use client'

import Link from 'next/link'
import { useState } from 'react'

export default function Navigation() {
  const [isOpen, setIsOpen] = useState(false)

  return (
    <nav className="bg-hotpink-dark text-white shadow-lg sticky top-0 z-50">
      <div className="max-w-7xl mx-auto px-4">
        <div className="flex justify-between items-center h-16">
          <Link href="/" className="text-2xl font-bold flex items-center gap-2">
            <span className="text-3xl">🤰🏾</span>
            <span>MamaHub African</span>
          </Link>

          {/* Desktop Menu */}
          <div className="hidden md:flex gap-8">
            <Link href="/" className="hover:text-gold transition">Dashboard</Link>
            <Link href="/meals" className="hover:text-gold transition">Meals</Link>
            <Link href="/exercises" className="hover:text-gold transition">Exercises</Link>
            <Link href="/tips" className="hover:text-gold transition">Tips</Link>
            <Link href="/symptoms" className="hover:text-gold transition">Symptoms</Link>
            <Link href="/tools" className="hover:text-gold transition">Tools</Link>
            <Link href="/baby-tracker" className="hover:text-gold transition">Baby Tracker</Link>
            <Link href="/community" className="hover:text-gold transition">Community</Link>
          </div>

          {/* Mobile Menu Button */}
          <button 
            onClick={() => setIsOpen(!isOpen)}
            className="md:hidden p-2"
          >
            <svg className="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
              <path strokeLinecap="round" strokeLinejoin="round" strokeWidth={2} d="M4 6h16M4 12h16M4 18h16" />
            </svg>
          </button>
        </div>

        {/* Mobile Menu */}
        {isOpen && (
          <div className="md:hidden pb-4 space-y-2">
            <Link href="/" className="block py-2 hover:text-gold">Dashboard</Link>
            <Link href="/meals" className="block py-2 hover:text-gold">Meals</Link>
            <Link href="/exercises" className="block py-2 hover:text-gold">Exercises</Link>
            <Link href="/tips" className="block py-2 hover:text-gold">Tips</Link>
            <Link href="/symptoms" className="block py-2 hover:text-gold">Symptoms</Link>
            <Link href="/tools" className="block py-2 hover:text-gold">Tools</Link>
            <Link href="/baby-tracker" className="block py-2 hover:text-gold">Baby Tracker</Link>
            <Link href="/community" className="block py-2 hover:text-gold">Community</Link>
          </div>
        )}
      </div>
    </nav>
  )
}
