'use client'

export default function PregnancyMilestones() {
  const milestones = [
    {
      id: 1,
      week: 'Week 4-8',
      title: 'The Beginning',
      description: 'Heart begins beating, baby is the size of a grain of rice',
      icon: '❤️',
      color: 'border-red-500'
    },
    {
      id: 2,
      week: 'Week 12-16',
      title: 'First Kicks',
      description: 'Baby can now move and stretch, you might feel first movements',
      icon: '🦵',
      color: 'border-pink-500'
    },
    {
      id: 3,
      week: 'Week 20-24',
      title: 'Halfway There',
      description: 'Baby is forming fingerprints, personality develops',
      icon: '👋',
      color: 'border-yellow-500'
    },
    {
      id: 4,
      week: 'Week 28-32',
      title: 'Final Trimester',
      description: 'Baby gaining weight rapidly, opening and closing eyes',
      icon: '👀',
      color: 'border-green-500'
    },
    {
      id: 5,
      week: 'Week 36-40',
      title: 'Ready to Meet',
      description: 'Baby is fully developed and ready for arrival',
      icon: '🎉',
      color: 'border-purple-500'
    }
  ]

  return (
    <section className="py-12 px-4 bg-gradient-to-r from-hotpink/5 to-hotpink-light/5">
      <div className="max-w-6xl mx-auto">
        <h2 className="text-3xl font-bold text-center mb-2 text-hotpink">Pregnancy Milestone Infographics</h2>
        <p className="text-center text-gray-600 mb-8">Track your beautiful journey from conception to birth</p>
        
        <div className="space-y-6">
          {milestones.map((milestone, index) => (
            <div key={milestone.id} className="flex gap-4 md:gap-8">
              {/* Timeline Line */}
              <div className="flex flex-col items-center">
                <div className={`w-4 h-4 rounded-full ${milestone.color.replace('border-', 'bg-')} border-4 border-white shadow-lg`}></div>
                {index !== milestones.length - 1 && <div className="w-1 h-24 bg-gray-300 mt-4"></div>}
              </div>

              {/* Content */}
              <div className={`milestone-card ${milestone.color} bg-white rounded-lg shadow-md mb-4 flex-1`}>
                <div className="flex items-start gap-4">
                  <div className="text-4xl">{milestone.icon}</div>
                  <div>
                    <div className="text-sm font-semibold text-orange-600">{milestone.week}</div>
                    <h3 className="text-xl font-bold text-earth mb-1">{milestone.title}</h3>
                    <p className="text-gray-600">{milestone.description}</p>
                  </div>
                </div>
              </div>
            </div>
          ))}
        </div>
      </div>
    </section>
  )
}
