'use client'

import { useState } from 'react'

export default function TipsAndArticles() {
  const [selectedCategory, setSelectedCategory] = useState('wisdom')

  const content = {
    wisdom: [
      {
        id: 1,
        title: 'The Power of Community Support',
        author: 'Traditional African Birth Wisdom',
        category: 'African Wisdom',
        date: 'Feb 2024',
        readTime: '5 min read',
        excerpt: 'In African cultures, pregnancy is not a solitary journey but a community experience. Surround yourself with other women who have walked this path.',
        content: `Historically, expectant mothers in African communities were supported by a network of women - mothers, grandmothers, aunts, and experienced peers. This wasn't just emotional support; it was practical wisdom, encouragement, and shared knowledge.

Today, you can recreate this circle:
• Join local mother groups or birth clubs
• Connect with other pregnant women online
• Spend time with your mother or female elders
• Share experiences and learn from others
• Build relationships that extend beyond pregnancy

This community connection reduces anxiety, improves outcomes, and creates bonds that last a lifetime.`,
        image: '👥'
      },
      {
        id: 2,
        title: 'Honoring Your Body\'s Changes',
        author: 'Swazi Traditional Medicine',
        category: 'African Wisdom',
        date: 'Feb 2024',
        readTime: '6 min read',
        excerpt: 'Your body is not just changing - it\'s creating life. Celebrate every transformation as a sign of strength.',
        content: `African mothers have long understood that pregnancy changes are not flaws but miracles. Stretch marks become "tiger stripes" - marks of a warrior mother. Your growing belly represents abundance and blessing.

Practices to honor your body:
• Daily body affirmations in front of the mirror
• Massage with natural oils (shea butter, coconut oil)
• Celebrate your growing strength
• Wear clothes that make you feel beautiful
• Take pregnancy photos to commemorate this time
• Share your journey with loved ones

Remember: These changes are temporary, beautiful, and represent the incredible work your body is doing.`,
        image: '🌸'
      },
      {
        id: 3,
        title: 'The Role of Ginger in Pregnancy',
        author: 'East African Herbal Traditions',
        category: 'African Wisdom',
        date: 'Feb 2024',
        readTime: '4 min read',
        excerpt: 'Ginger has been used for centuries in African pregnancy care to ease nausea and support digestion.',
        content: `Ginger is a staple in African pregnancy care:

Benefits:
• Reduces morning sickness and nausea
• Aids digestive health
• Anti-inflammatory properties
• Improves circulation
• Supports immune system

How to use:
• Ginger tea (1 inch fresh ginger brewed in hot water)
• Added to meals and soups
• Ginger candies for quick relief
• Ginger root as a natural remedy

Always consult your healthcare provider about quantities, as too much ginger can affect some pregnancies.`,
        image: '🌿'
      }
    ],
    articles: [
      {
        id: 4,
        title: 'Nutrition During Pregnancy: African Perspectives',
        author: 'Dr. Amina Okafor',
        category: 'Nutrition',
        date: 'Feb 2024',
        readTime: '8 min read',
        excerpt: 'Discover how traditional African foods provide complete nutrition for mother and baby.',
        content: `African staple foods are nutritionally complete:

Proteins:
• Legumes (beans, lentils, peas) - excellent source of folate
• Fish and seafood - omega-3 fatty acids
• Eggs - complete protein
• Groundnuts - healthy fats and minerals

Iron sources:
• Leafy greens (moringa, collards, spinach)
• Red meat
• Fortified grains
• Dried fruits

Building balanced meals:
• Include a protein at each meal
• Add colorful vegetables and fruits
• Choose whole grains
• Include healthy fats
• Stay hydrated with water and traditional drinks

These foods aren't just nutritious - they're cultural heritage!`,
        image: '🍲'
      },
      {
        id: 5,
        title: 'Sleep Positions for Pregnancy Comfort',
        author: 'Midwife Maria Santos',
        category: 'Health',
        date: 'Feb 2024',
        readTime: '5 min read',
        excerpt: 'Traditional sleeping practices that promote better rest and optimal baby positioning.',
        content: `Better sleep positions:

Side sleeping (best):
• Lie on your left side to improve circulation
• Place pillow between knees
• Support your belly with a pillow
• This position ensures maximum blood flow to placenta

How to get comfortable:
• Use multiple pillows strategically
• Elevate your upper body slightly
• Keep room cool and dark
• Avoid sleeping flat on your back after first trimester
• Use pregnancy pillow for support

Tips for better sleep:
• Sleep in cooler room
• Avoid screens 1 hour before bed
• Gentle music or nature sounds
• Meditation or relaxation exercises
• Consistent bedtime routine`,
        image: '😴'
      },
      {
        id: 6,
        title: 'Managing Pregnancy Emotions',
        author: 'Counselor Fatima Hassan',
        category: 'Mental Health',
        date: 'Feb 2024',
        readTime: '7 min read',
        excerpt: 'Hormonal changes bring emotional shifts. Here\'s how to navigate them with grace.',
        content: `It's normal to experience:
• Mood swings
• Increased anxiety
• Emotional sensitivity
• Joy and excitement
• Unexpected tears

Healthy coping strategies:
• Talk to trusted friends and family
• Journal your feelings
• Practice deep breathing
• Gentle exercise (walking, yoga)
• Creative expression (art, music)
• Professional counseling if needed

Remember:
• Your emotions are valid
• This is temporary
• You're not alone
• Seek help when needed
• Your mental health matters as much as your physical health`,
        image: '❤️'
      }
    ],
    tips: [
      {
        id: 7,
        title: 'Quick Nausea Relief Tips',
        tips: [
          'Ginger tea first thing in the morning',
          'Small, frequent meals instead of large ones',
          'Crackers before getting out of bed',
          'Fresh air and open windows',
          'Lemon water or peppermint tea',
          'Acupressure bands on wrists'
        ],
        icon: '🤢'
      },
      {
        id: 8,
        title: 'Back Pain Relief Strategies',
        tips: [
          'Prenatal massage with trained therapist',
          'Supportive pillows for sleeping',
          'Prenatal yoga and stretching',
          'Warm (not hot) compress on lower back',
          'Proper posture during daily activities',
          'Gentle exercises to strengthen core'
        ],
        icon: '🤕'
      },
      {
        id: 9,
        title: 'Managing Swelling (Edema)',
        tips: [
          'Elevate feet when sitting or lying',
          'Stay well-hydrated with water',
          'Avoid standing for long periods',
          'Wear compression socks',
          'Reduce salt intake',
          'Gentle foot and leg massages'
        ],
        icon: '🦵'
      },
      {
        id: 10,
        title: 'Energy Boost Techniques',
        tips: [
          'Short power naps (15-20 mins)',
          'Nutritious snacks between meals',
          'Light exercise and movement',
          'Adequate iron-rich foods',
          'Morning sunlight exposure',
          'Positive social interactions'
        ],
        icon: '⚡'
      }
    ]
  }

  const categories = [
    { key: 'wisdom', label: '✨ African Wisdom', icon: '🌍' },
    { key: 'articles', label: '📚 Full Articles', icon: '📖' },
    { key: 'tips', label: '💡 Quick Tips', icon: '⚡' }
  ]

  return (
    <div className="space-y-6">
      {/* Header */}
      <div className="bg-gradient-to-r from-hotpink to-hotpink-dark rounded-2xl p-8 text-white">
        <h1 className="text-4xl font-bold mb-2">Tips & African Wisdom</h1>
        <p className="text-lg opacity-90">Learn from centuries of African pregnancy knowledge 📖</p>
      </div>

      {/* Category Selector */}
      <div className="bg-white rounded-xl border-2 border-hotpink-light p-6">
        <h2 className="text-xl font-bold text-hotpink mb-4">Select Content Type</h2>
        <div className="grid md:grid-cols-3 gap-4">
          {categories.map((cat) => (
            <button
              key={cat.key}
              onClick={() => setSelectedCategory(cat.key)}
              className={`p-4 rounded-lg font-bold transition ${
                selectedCategory === cat.key
                  ? 'bg-hotpink text-white'
                  : 'bg-white border-2 border-hotpink-light text-hotpink hover:bg-hotpink/10'
              }`}
            >
              {cat.icon} {cat.label}
            </button>
          ))}
        </div>
      </div>

      {/* Content */}
      {selectedCategory === 'wisdom' && (
        <div className="space-y-4">
          {content.wisdom.map((article) => (
            <div key={article.id} className="bg-white rounded-xl border-2 border-hotpink-light p-6 hover:shadow-lg transition">
              <div className="flex gap-4">
                <div className="text-5xl flex-shrink-0">{article.image}</div>
                <div className="flex-1">
                  <div className="flex items-start justify-between mb-2">
                    <div>
                      <p className="text-sm font-semibold text-hotpink">{article.author}</p>
                      <h3 className="text-2xl font-bold text-deepbrown">{article.title}</h3>
                    </div>
                    <p className="text-xs text-gray-500 whitespace-nowrap ml-4">{article.readTime}</p>
                  </div>
                  
                  <p className="text-gray-700 mb-4">{article.excerpt}</p>
                  
                  <button className="bg-hotpink hover:bg-hotpink-dark text-white font-bold py-2 px-4 rounded-lg transition">
                    Read Full Article
                  </button>
                </div>
              </div>
            </div>
          ))}
        </div>
      )}

      {selectedCategory === 'articles' && (
        <div className="space-y-4">
          {content.articles.map((article) => (
            <div key={article.id} className="bg-white rounded-xl border-2 border-hotpink-light p-6 hover:shadow-lg transition">
              <div className="flex gang-4">
                <div className="text-5xl mr-4 flex-shrink-0">{article.image}</div>
                <div className="flex-1">
                  <div className="flex items-start justify-between mb-2">
                    <div>
                      <p className="text-sm font-semibold text-hotpink">{article.category}</p>
                      <h3 className="text-2xl font-bold text-deepbrown">{article.title}</h3>
                    </div>
                    <p className="text-xs text-gray-500 whitespace-nowrap ml-4">{article.readTime}</p>
                  </div>
                  
                  <p className="text-gray-600 text-sm mb-3">by {article.author}</p>
                  <p className="text-gray-700 mb-4">{article.excerpt}</p>
                  
                  <button className="bg-hotpink hover:bg-hotpink-dark text-white font-bold py-2 px-4 rounded-lg transition">
                    Read Article
                  </button>
                </div>
              </div>
            </div>
          ))}
        </div>
      )}

      {selectedCategory === 'tips' && (
        <div className="grid md:grid-cols-2 gap-4">
          {content.tips.map((tip) => (
            <div key={tip.id} className="bg-white rounded-xl border-2 border-hotpink-light p-6 hover:shadow-lg transition">
              <h3 className="text-2xl font-bold text-deepbrown mb-4 flex items-center gap-2">
                <span>{tip.icon}</span>
                {tip.title}
              </h3>
              
              <ul className="space-y-2">
                {tip.tips.map((item, idx) => (
                  <li key={idx} className="flex gap-2 text-gray-700">
                    <span className="text-hotpink font-bold flex-shrink-0">✓</span>
                    <span>{item}</span>
                  </li>
                ))}
              </ul>

              <button className="w-full mt-4 bg-hotpink/10 hover:bg-hotpink/20 text-hotpink font-bold py-2 rounded-lg transition">
                Save These Tips
              </button>
            </div>
          ))}
        </div>
      )}

      {/* Featured Section */}
      <div className="bg-gradient-to-r from-terra/20 to-terracotta/20 rounded-xl border-2 border-terra p-8">
        <h3 className="text-2xl font-bold text-deepbrown mb-4">🌍 African Mothers Across Time</h3>
        <div className="grid md:grid-cols-3 gap-6">
          <div>
            <p className="font-bold text-terra mb-2">West African Wisdom:</p>
            <p className="text-gray-700 text-sm">Pregnancy is celebrated as a time of spiritual growth and connection to ancestors. Community gatherings and rituals support the mother's journey.</p>
          </div>
          <div>
            <p className="font-bold text-terra mb-2">East African Practices:</p>
            <p className="text-gray-700 text-sm">Emphasis on natural movement, herbal remedies, and the importance of experienced midwives. Birth is seen as a natural, powerful event.</p>
          </div>
          <div>
            <p className="font-bold text-terra mb-2">Southern African Traditions:</p>
            <p className="text-gray-700 text-sm">Focus on family support, ancestral blessing, and the role of elders. Pregnancy rituals prepare both mother and community.</p>
          </div>
        </div>
      </div>
    </div>
  )
}
